/******************************************************************************
 * Copyright (c) 2018 Oracle
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * SPDX-License-Identifier: EPL-2.0
 ******************************************************************************/

package org.eclipse.glassfish.tools.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.sdk.server.FetchLog;

// TODO will be GlassfishLocalConsole in the future, new GlassfishRemoteConsole to be implemented
public class GlassfishConsole extends AbstractGlassfishConsole implements IGlassFishConsole {

	private static ScheduledExecutorService stopService = Executors.newSingleThreadScheduledExecutor();
	
	private StopJob job = new StopJob();
	
	GlassfishConsole(String name, ILogFilter filter) {
		super(name, 
				GlassfishToolsPlugin.getInstance().getImageRegistry().getDescriptor(GlassfishToolsPlugin.GF_SERVER_IMG),
				filter);
	}
	
//	GlassfishConsole(String name, FetchLog[] logFetchers) {
//		this(name);
//	}
//	
//	GlassfishConsole(String name, FetchLog logFetcher) {
//		this(name, new FetchLog[] {logFetcher});
//	}

	@Override
	public void startLogging() {
		// will work after we make fetchlog class runnable more than once
//		stopLogging();
//		readers = new ArrayList<LogReader>(logFetchers.length);
//		out = newMessageStream();
//		for (FetchLog logFetcher : logFetchers) {
//			LogReader reader = new LogReader(logFetcher, out);
//			readers.add(reader);
//			Thread t = new Thread(reader);
//			t.start();
//		}
	}

	@Override
	public synchronized void startLogging(FetchLog... logFetchers) {
		if (stopJobResult != null) {
			try {
				//System.out.println("stop job result get started");
				stopJobResult.get();
				//System.out.println("stop job result get finished");
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			stopJobResult = null;
		} else {
			System.out.println("stopJobResult is null in console " + getName());
			stopLoggingImpl();
		}
		readers = new ArrayList<LogReader>(logFetchers.length);
		latch = new CountDownLatch(logFetchers.length);
		filter.reset();
		int i = 0;
		for (FetchLog logFetcher : logFetchers) {
			LogReader reader = new LogReader(logFetcher, out, latch, filter);
			readers.add(reader);
			Thread t = new Thread(reader, "LogReader Thread" + i++);
			t.start();
		}
	}
	
	@Override
	public synchronized void stopLogging() {
		if (isLogging())
			stopLoggingImpl();
	}
	
	private void stopLoggingImpl() {
		if (readers == null)
			return;
		for (LogReader r : readers) {
			r.stop();
		}
		readers = null;
	}
	
	@Override
	public synchronized void stopLogging(int afterSeconds) {
		if (isLogging())
			stopJobResult = stopService.schedule(job, afterSeconds, TimeUnit.SECONDS);
		//System.out.println("stop job scheduled");
	}

	@Override
	protected void dispose() {
		super.dispose();
		stopLogging();
		try {
			latch.await();
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	@Override
	public synchronized boolean isLogging() {
		boolean isLogging = (readers != null) && (readers.size() > 0) && (stopJobResult == null);
		//System.out.println("isLogging " + isLogging);
		return isLogging;
	}

	@Override
	public synchronized void setLogFilter(ILogFilter filter) {
		this.filter = filter;
	}
	
	class StopJob implements Runnable {

		@Override
		public void run() {
			//System.out.println("cleanup job");
			stopLoggingImpl();
		}
		
	}
	
}
