/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.FastStringWriter;
import com.sun.webui.jsf.util.RenderingUtilities;
import java.io.IOException;
import java.io.Writer;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WidgetUtilities {
    public static void addProperties(JSONArray json, String value) throws JSONException {
        if (value != null) {
            try {
                json.put((Object)new JSONObject(value));
            }
            catch (JSONException e) {
                json.put((Object)value);
            }
        }
    }

    public static void addProperties(JSONObject json, String key, String value) throws JSONException {
        if (value != null) {
            try {
                json.put(key, (Object)new JSONObject(value));
            }
            catch (JSONException e) {
                json.put(key, (Object)value);
            }
        }
    }

    public static String renderComponent(FacesContext context, UIComponent component) throws IOException, JSONException {
        if (component == null || !component.isRendered()) {
            return null;
        }
        ResponseWriter oldWriter = context.getResponseWriter();
        Writer strWriter = WidgetUtilities.initStringWriter(context);
        RenderingUtilities.renderComponent(component, context);
        context.setResponseWriter(oldWriter);
        return strWriter.toString();
    }

    protected static Writer initStringWriter(FacesContext context) {
        if (context == null) {
            return null;
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        ResponseWriter oldWriter = context.getResponseWriter();
        FastStringWriter strWriter = new FastStringWriter(1024);
        ResponseWriter newWriter = null;
        if (null != oldWriter) {
            newWriter = oldWriter.cloneWithWriter((Writer)strWriter);
        } else {
            ExternalContext extContext = context.getExternalContext();
            ServletRequest request = (ServletRequest)extContext.getRequest();
            newWriter = renderKit.createResponseWriter((Writer)strWriter, null, request.getCharacterEncoding());
        }
        context.setResponseWriter(newWriter);
        return strWriter;
    }
}

