/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.SubscriptionIterator;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class ClusterSubscriptionInfo {
    private Subscription subscription = null;
    private Consumer consumer = null;
    private Cluster c = null;
    private GPacket pkt = null;

    private ClusterSubscriptionInfo(Subscription sub) {
        this.subscription = sub;
    }

    private ClusterSubscriptionInfo(Subscription sub, Consumer cs, Cluster c) {
        this.subscription = sub;
        this.consumer = cs;
        this.c = c;
    }

    private ClusterSubscriptionInfo(GPacket pkt) {
        this(pkt, null);
    }

    private ClusterSubscriptionInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterSubscriptionInfo newInstance(Subscription sub) {
        return new ClusterSubscriptionInfo(sub);
    }

    public static ClusterSubscriptionInfo newInstance(Subscription sub, Consumer cs, Cluster c) {
        return new ClusterSubscriptionInfo(sub, cs, c);
    }

    public static ClusterSubscriptionInfo newInstance(GPacket pkt) {
        return new ClusterSubscriptionInfo(pkt);
    }

    public static ClusterSubscriptionInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterSubscriptionInfo(pkt, c);
    }

    public GPacket getGPacket(short protocol) {
        return this.getGPacket(protocol, false);
    }

    public GPacket getGPacket(short protocol, boolean changeRecord) {
        assert (this.subscription != null);
        assert (protocol == 5 || protocol == 35 || protocol == 7);
        if (changeRecord) assert (protocol == 5 || protocol == 7);
        GPacket gp = null;
        switch (protocol) {
            case 5: {
                ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(this.subscription, null);
                gp = cci.getGPacket(protocol);
                if (changeRecord) {
                    gp.putProp("N", this.subscription.getDurableName());
                    String clientID = this.subscription.getClientID();
                    gp.putProp("I", clientID == null ? "" : clientID);
                    gp.putProp("M", true);
                    gp.putProp("shared", this.subscription.getShared());
                    gp.putProp("jmsshared", this.subscription.getJMSShared());
                    break;
                }
                ChangeRecordInfo cri = this.subscription.getCurrentChangeRecordInfo(5);
                if (cri == null) break;
                gp.putProp("shareccSeq1", cri.getSeq());
                gp.putProp("shareccUUID1", cri.getUUID());
                gp.putProp("shareccResetUUID1", cri.getResetUUID());
                break;
            }
            case 35: {
                int prefetch;
                String clientID;
                assert (this.consumer != null);
                gp = GPacket.getInstance();
                gp.setType(protocol);
                String dname = this.subscription.getDurableName();
                if (dname != null) {
                    gp.putProp("N", dname);
                }
                gp.putProp("I", (clientID = this.subscription.getClientID()) == null ? "" : clientID);
                String ndsubname = this.subscription.getNDSubscriptionName();
                if (ndsubname != null) {
                    gp.putProp("NDN", ndsubname);
                }
                ClusterManager cm = Globals.getClusterManager();
                int csize = 1;
                if (cm != null && (csize = cm.getConfigBrokerCount()) <= 0) {
                    csize = 1;
                }
                if ((prefetch = this.consumer.getPrefetchForRemote() / csize) <= 0) {
                    prefetch = 1;
                }
                gp.putProp(String.valueOf(this.consumer.getConsumerUID().longValue()) + ":" + "prefetch", prefetch);
                gp.putProp("allowsNonDurable", true);
                this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                try {
                    ClusterConsumerInfo.writeConsumer(this.consumer, dos);
                    dos.flush();
                    bos.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gp.setPayload(ByteBuffer.wrap(bos.toByteArray()));
                break;
            }
            case 7: {
                gp = GPacket.getInstance();
                gp.setType(protocol);
                gp.putProp("C", 1);
                String dname = this.subscription.getDurableName();
                String clientID = this.subscription.getClientID();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                try {
                    dos.writeUTF(dname);
                    dos.writeUTF(clientID == null ? "" : clientID);
                    dos.flush();
                    bos.flush();
                }
                catch (IOException csize) {
                    // empty catch block
                }
                gp.setPayload(ByteBuffer.wrap(bos.toByteArray()));
                if (changeRecord) {
                    gp.putProp("N", dname);
                    gp.putProp("I", clientID == null ? "" : clientID);
                    gp.putProp("M", true);
                    break;
                }
                ChangeRecordInfo cri = this.subscription.getCurrentChangeRecordInfo(7);
                if (cri == null) break;
                gp.putProp("shareccSeq1", cri.getSeq());
                gp.putProp("shareccUUID1", cri.getUUID());
                gp.putProp("shareccResetUUID1", cri.getResetUUID());
            }
        }
        return gp;
    }

    public int getConsumerCount() {
        assert (this.pkt != null);
        short type = this.pkt.getType();
        assert (type == 5 || type == 9 || type == 7);
        int count = (Integer)this.pkt.getProp("C");
        assert (count == 1);
        return count;
    }

    public ChangeRecordInfo getShareccInfo(int i) {
        if (this.pkt.getProp("shareccSeq" + i) == null) {
            return null;
        }
        ChangeRecordInfo cri = new ChangeRecordInfo();
        cri.setSeq((Long)this.pkt.getProp("shareccSeq" + i));
        cri.setUUID((String)this.pkt.getProp("shareccUUID" + i));
        cri.setResetUUID((String)this.pkt.getProp("shareccResetUUID" + i));
        cri.setType(this.pkt.getType());
        return cri;
    }

    public boolean isConfigSyncResponse() {
        assert (this.pkt != null);
        boolean b = false;
        if (this.pkt.getProp("M") != null) {
            b = (Boolean)this.pkt.getProp("M");
        }
        return b;
    }

    public String getDurableName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("N");
    }

    public String getClientID() {
        assert (this.pkt != null);
        String clientID = (String)this.pkt.getProp("I");
        if (clientID == null || clientID.length() == 0) {
            return null;
        }
        return clientID;
    }

    public Boolean getShared() {
        assert (this.pkt != null);
        Boolean b = (Boolean)this.pkt.getProp("shared");
        if (b != null) {
            b = (boolean)b;
        }
        return b;
    }

    public Boolean getJMSShared() {
        assert (this.pkt != null);
        Boolean b = (Boolean)this.pkt.getProp("jmsshared");
        if (b != null) {
            b = (boolean)b;
        }
        return b;
    }

    public String getNDSubscriptionName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp("NDN");
    }

    public Boolean allowsNonDurable() {
        assert (this.pkt != null);
        return (Boolean)this.pkt.getProp("allowsNonDurable");
    }

    public Consumer getConsumer() throws Exception {
        BrokerAddress from;
        assert (this.pkt != null);
        short type = this.pkt.getType();
        assert (type == 35);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.pkt.getPayload().array());
        DataInputStream dis = new DataInputStream(bis);
        Consumer cs = ClusterConsumerInfo.readConsumer(dis);
        Integer prefetch = (Integer)this.pkt.getProp(String.valueOf(cs.getConsumerUID().longValue()) + ":" + "prefetch");
        if (prefetch != null) {
            cs.setRemotePrefetch(prefetch);
        }
        if ((from = this.c.unmarshalBrokerAddress(this.pkt)) != null) {
            cs.getConsumerUID().setBrokerAddress(from);
        }
        return cs;
    }

    public Iterator getSubscriptions() {
        assert (this.pkt != null);
        short type = this.pkt.getType();
        assert (type == 7);
        return new SubscriptionIterator(this.pkt.getPayload().array(), this.getConsumerCount());
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public static GPacket getReplyGPacket(short protocol, int status) {
        GPacket gp = GPacket.getInstance();
        gp.setType(protocol);
        gp.putProp("S", status);
        return gp;
    }
}

