/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.services.IServiceLocator;

public class ActionBars
extends SubActionBars {
    private ToolBarManager toolbarManager;
    private IMenuManager menuManager;
    private MPart part;

    public ActionBars(IActionBars parent, IServiceLocator serviceLocator, MPart part) {
        super(parent, serviceLocator);
        this.part = part;
    }

    @Override
    public IMenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
        }
        return this.menuManager;
    }

    @Override
    public IToolBarManager getToolBarManager() {
        if (this.toolbarManager == null) {
            this.toolbarManager = new ToolBarManager(8519744);
        }
        return this.toolbarManager;
    }

    @Override
    public void updateActionBars() {
        this.getStatusLineManager().update(false);
        if (this.toolbarManager != null) {
            Object renderer;
            this.toolbarManager.update(true);
            MToolBar toolbar = this.part.getToolbar();
            if (toolbar != null && (renderer = toolbar.getRenderer()) instanceof ToolBarManagerRenderer) {
                ((ToolBarManagerRenderer)renderer).reconcileManagerToModel((IToolBarManager)this.toolbarManager, toolbar);
            }
        }
        if (this.menuManager != null) {
            this.menuManager.update(false);
            this.forceUpdateTopRight();
        }
        super.updateActionBars();
    }

    private void forceUpdateTopRight() {
        MElementContainer parentElement;
        MPart element = this.part;
        if (element.getCurSharedRef() != null) {
            element = element.getCurSharedRef();
        }
        if (!((parentElement = element.getParent()) instanceof MPartStack)) {
            return;
        }
        Object widget = parentElement.getWidget();
        if (widget instanceof CTabFolder) {
            ((StackRenderer)parentElement.getRenderer()).adjustTopRight((CTabFolder)widget);
        }
    }

    @Override
    public void dispose() {
        this.menuManager.dispose();
        if (this.toolbarManager != null) {
            this.toolbarManager.dispose();
            this.toolbarManager.removeAll();
        }
        super.dispose();
    }
}

