/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.specification.GenericEMFPatternPQuery;
import org.eclipse.incquery.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.incquery.patternlanguage.emf.specification.XBaseEvaluator;
import org.eclipse.incquery.patternlanguage.emf.types.IEMFTypeProvider;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.emf.types.JavaTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.psystem.IValueProvider;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IQuerySpecification} implementation inferrer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternQuerySpecificationClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private IEMFTypeProvider _iEMFTypeProvider;
  
  @Inject
  private IErrorFeedback feedback;
  
  @Inject
  private Logger logger;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  @Extension
  private JvmAnnotationReferenceBuilder annBuilder;
  
  /**
   * Infers the {@link IQuerySpecification} implementation class from {@link Pattern}.
   */
  public JvmDeclaredType inferQuerySpecificationClass(final Pattern pattern, final boolean isPrelinkingPhase, final String querySpecificationPackageName, final JvmType matcherClass, final JvmTypeReferenceBuilder builder, final JvmAnnotationReferenceBuilder annBuilder) {
    this.builder = builder;
    this.annBuilder = annBuilder;
    String _querySpecificationClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        it.setPackageName(querySpecificationPackageName);
        CharSequence _javadocQuerySpecificationClass = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationClass(pattern);
        String _string = _javadocQuerySpecificationClass.toString();
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        it.setFinal(true);
        boolean _isPublic = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(pattern);
        if (_isPublic) {
          EList<JvmTypeReference> _superTypes = it.getSuperTypes();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(matcherClass);
          JvmTypeReference _typeRef_1 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(BaseGeneratedEMFQuerySpecification.class, _typeRef);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef_1);
        } else {
          EList<JvmTypeReference> _superTypes_1 = it.getSuperTypes();
          JvmTypeReference _typeRef_2 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IPatternMatch.class);
          JvmTypeReference _typeRef_3 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(matcherClass, _typeRef_2);
          JvmTypeReference _typeRef_4 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(BaseGeneratedEMFQuerySpecification.class, _typeRef_3);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes_1, _typeRef_4);
        }
      }
    };
    final JvmGenericType querySpecificationClass = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationClassName, _function);
    return querySpecificationClass;
  }
  
  public void initializePublicSpecification(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmType matcherClass, final JvmType matchClass, final SpecificationBuilder specBuilder) {
    this.inferQuerySpecificationMethods(querySpecificationClass, pattern, matcherClass, matchClass, true);
    this.inferQuerySpecificationInnerClasses(querySpecificationClass, pattern, true, specBuilder);
    this.inferExpressions(querySpecificationClass, pattern);
  }
  
  public void initializePrivateSpecification(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmType matcherClass, final JvmType matchClass, final SpecificationBuilder specBuilder) {
    querySpecificationClass.setVisibility(JvmVisibility.DEFAULT);
    this.inferQuerySpecificationMethods(querySpecificationClass, pattern, matcherClass, matchClass, false);
    this.inferQuerySpecificationInnerClasses(querySpecificationClass, pattern, false, specBuilder);
    this.inferExpressions(querySpecificationClass, pattern);
  }
  
  /**
   * Infers methods for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationMethods(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmType matcherClass, final JvmType matchClass, final boolean isPublic) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = querySpecificationClass.getMembers();
      final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
        @Override
        public void apply(final JvmConstructor it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("super(");
              String _querySpecificationPQueryClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationPQueryClassName(pattern);
              _builder.append(_querySpecificationPQueryClassName, "");
              _builder.append(".INSTANCE);");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
      this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
      EList<JvmMember> _members_1 = querySpecificationClass.getMembers();
      JvmTypeReference _typeRef = this.builder.typeRef(querySpecificationClass);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          it.setStatic(true);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
          CharSequence _javadocQuerySpecificationInstanceMethod = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationInstanceMethod(pattern);
          String _string = _javadocQuerySpecificationInstanceMethod.toString();
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("try{");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("return ");
              String _querySpecificationHolderClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationHolderClassName(pattern);
              _builder.append(_querySpecificationHolderClassName, "\t");
              _builder.append(".INSTANCE;");
              _builder.newLineIfNotEmpty();
              _builder.append("} catch (");
              _builder.append(ExceptionInInitializerError.class, "");
              _builder.append(" err) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("throw processInitializerError(err);");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "instance", _typeRef, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      EList<JvmMember> _members_2 = querySpecificationClass.getMembers();
      JvmTypeReference _typeRef_1 = this.builder.typeRef(matcherClass);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IncQueryEngine.class);
          JvmFormalParameter _parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "engine", _typeRef);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef_1 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef_1);
          StringConcatenationClient _xifexpression = null;
          if (isPublic) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                String _matcherClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
                _builder.append(_matcherClassName, "");
                _builder.append(".on(engine);");
              }
            };
            _xifexpression = _client;
          } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("throw new ");
                _builder.append(UnsupportedOperationException.class, "");
                _builder.append("();");
              }
            };
            _xifexpression = _client_1;
          }
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _xifexpression);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "instantiate", _typeRef_1, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_1);
      EList<JvmMember> _members_3 = querySpecificationClass.getMembers();
      JvmTypeReference _xifexpression = null;
      if (isPublic) {
        _xifexpression = this.builder.typeRef(matchClass);
      } else {
        _xifexpression = this.builder.typeRef(IPatternMatch.class);
      }
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _xifexpression = null;
          if (isPublic) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                String _matchClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                _builder.append(_matchClassName, "");
                _builder.append(".newEmptyMatch();");
              }
            };
            _xifexpression = _client;
          } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("throw new ");
                _builder.append(UnsupportedOperationException.class, "");
                _builder.append("();");
              }
            };
            _xifexpression = _client_1;
          }
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _xifexpression);
        }
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "newEmptyMatch", _xifexpression, _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_2);
      EList<JvmMember> _members_4 = querySpecificationClass.getMembers();
      JvmTypeReference _xifexpression_1 = null;
      if (isPublic) {
        _xifexpression_1 = this.builder.typeRef(matchClass);
      } else {
        _xifexpression_1 = this.builder.typeRef(IPatternMatch.class);
      }
      final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(Object.class);
          JvmTypeReference _addArrayTypeDimension = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_typeRef);
          JvmFormalParameter _parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "parameters", _addArrayTypeDimension);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          it.setVarArgs(true);
          StringConcatenationClient _xifexpression = null;
          if (isPublic) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("return ");
                String _matchClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                _builder.append(_matchClassName, "");
                _builder.append(".newMatch(");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    _builder.append("(");
                    JvmTypeReference _calculateType = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
                    String _qualifiedName = _calculateType.getQualifiedName();
                    _builder.append(_qualifiedName, "");
                    _builder.append(") parameters[");
                    EList<Variable> _parameters_1 = pattern.getParameters();
                    int _indexOf = _parameters_1.indexOf(p);
                    _builder.append(_indexOf, "");
                    _builder.append("]");
                  }
                }
                _builder.append(");");
              }
            };
            _xifexpression = _client;
          } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("throw new ");
                _builder.append(UnsupportedOperationException.class, "");
                _builder.append("();");
              }
            };
            _xifexpression = _client_1;
          }
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _xifexpression);
        }
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "newMatch", _xifexpression_1, _function_4);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_3);
    }
    return _xblockexpression;
  }
  
  public boolean inferPQueryMembers(final JvmDeclaredType pQueryClass, final Pattern pattern, final SpecificationBuilder specBuilder) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = pQueryClass.getMembers();
      JvmTypeReference _typeRef = this.builder.typeRef(pQueryClass);
      final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
        @Override
        public void apply(final JvmField it) {
          it.setFinal(true);
          it.setStatic(true);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("new ");
              String _querySpecificationPQueryClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationPQueryClassName(pattern);
              _builder.append(_querySpecificationPQueryClassName, "");
              _builder.append("()");
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
        }
      };
      JvmField _field = this._eMFJvmTypesBuilder.toField(pattern, "INSTANCE", _typeRef, _function);
      this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
      EList<JvmMember> _members_1 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_1 = this.builder.typeRef(String.class);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return \"");
              String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
              _builder.append(_fullyQualifiedName, "");
              _builder.append("\";");
              _builder.newLineIfNotEmpty();
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "getFullyQualifiedName", _typeRef_1, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      EList<JvmMember> _members_2 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_2 = this.builder.typeRef(String.class);
      JvmTypeReference _typeRef_3 = this.builder.typeRef(List.class, _typeRef_2);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              _builder.append(Arrays.class, "");
              _builder.append(".asList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable param : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(",", "");
                  }
                  _builder.append("\"");
                  String _name = param.getName();
                  _builder.append(_name, "");
                  _builder.append("\"");
                }
              }
              _builder.append(");");
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "getParameterNames", _typeRef_3, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_1);
      EList<JvmMember> _members_3 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_4 = this.builder.typeRef(PParameter.class);
      JvmTypeReference _typeRef_5 = this.builder.typeRef(List.class, _typeRef_4);
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              _builder.append(Arrays.class, "");
              _builder.append(".asList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable param : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(",", "");
                  }
                  CharSequence _parameterInstantiation = PatternQuerySpecificationClassInferrer.this.parameterInstantiation(param);
                  _builder.append(_parameterInstantiation, "");
                }
              }
              _builder.append(");");
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "getParameters", _typeRef_5, _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_2);
      EList<JvmMember> _members_4 = pQueryClass.getMembers();
      JvmTypeReference _typeRef_6 = this.builder.typeRef(PBody.class);
      JvmTypeReference _typeRef_7 = this.builder.typeRef(Set.class, _typeRef_6);
      final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = PatternQuerySpecificationClassInferrer.this.annBuilder.annotationRef(Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(QueryInitializationException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
          try {
            final IQuerySpecification<?> genericSpecification = specBuilder.getOrCreateSpecification(pattern, true);
            boolean _or = false;
            boolean _or_1 = false;
            boolean _equals = Objects.equal(genericSpecification, null);
            if (_equals) {
              _or_1 = true;
            } else {
              PQuery _internalQueryRepresentation = genericSpecification.getInternalQueryRepresentation();
              boolean _equals_1 = Objects.equal(_internalQueryRepresentation, null);
              _or_1 = _equals_1;
            }
            if (_or_1) {
              _or = true;
            } else {
              PQuery _internalQueryRepresentation_1 = genericSpecification.getInternalQueryRepresentation();
              PQuery.PQueryStatus _status = _internalQueryRepresentation_1.getStatus();
              boolean _equals_2 = Objects.equal(_status, PQuery.PQueryStatus.ERROR);
              _or = _equals_2;
            }
            if (_or) {
              PatternQuerySpecificationClassInferrer.this.feedback.reportError(pattern, "Error building generic query specification", 
                EMFPatternLanguageJvmModelInferrer.SPECIFICATION_BUILDER_CODE, Severity.ERROR, 
                IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
            }
            boolean _or_2 = false;
            boolean _equals_3 = Objects.equal(genericSpecification, null);
            if (_equals_3) {
              _or_2 = true;
            } else {
              PQuery _internalQueryRepresentation_2 = genericSpecification.getInternalQueryRepresentation();
              boolean _equals_4 = Objects.equal(_internalQueryRepresentation_2, null);
              _or_2 = _equals_4;
            }
            if (_or_2) {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("addError(new ");
                  _builder.append(PProblem.class, "");
                  _builder.append("(\"Could not initialize query specification from the pattern definition\"));");
                  _builder.newLineIfNotEmpty();
                  _builder.append("return null;");
                  _builder.newLine();
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
            } else {
              StringConcatenationClient _client_1 = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(Set.class, "");
                  _builder.append("<");
                  _builder.append(PBody.class, "");
                  _builder.append("> bodies = ");
                  _builder.append(Sets.class, "");
                  _builder.append(".newLinkedHashSet();");
                  _builder.newLineIfNotEmpty();
                  _builder.append("try {");
                  _builder.newLine();
                  _builder.append("\t");
                  StringConcatenationClient _inferBodies = PatternQuerySpecificationClassInferrer.this.inferBodies(pattern, genericSpecification);
                  _builder.append(_inferBodies, "\t");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  StringConcatenationClient _inferAnnotations = PatternQuerySpecificationClassInferrer.this.inferAnnotations(pattern, genericSpecification);
                  _builder.append(_inferAnnotations, "\t");
                  _builder.newLineIfNotEmpty();
                  {
                    PQuery _internalQueryRepresentation = genericSpecification.getInternalQueryRepresentation();
                    List<PProblem> _pProblems = _internalQueryRepresentation.getPProblems();
                    for(final PProblem problem : _pProblems) {
                      _builder.append("\t");
                      _builder.append("addError(new ");
                      _builder.append(PProblem.class, "\t");
                      _builder.append("(\"");
                      String _shortMessage = problem.getShortMessage();
                      String _escapeToQuotedString = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.escapeToQuotedString(_shortMessage);
                      _builder.append(_escapeToQuotedString, "\t");
                      _builder.append("\"));");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                  _builder.append("\t");
                  _builder.append("// to silence compiler error");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("if (false) throw new IncQueryException(\"Never\", \"happens\");");
                  _builder.newLine();
                  _builder.append("} catch (");
                  _builder.append(IncQueryException.class, "");
                  _builder.append(" ex) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("throw processDependencyException(ex);");
                  _builder.newLine();
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("return bodies;");
                  _builder.newLine();
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client_1);
            }
          } catch (final Throwable _t) {
            if (_t instanceof Exception) {
              final Exception e = (Exception)_t;
              StringConcatenationClient _client_2 = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("addError(new ");
                  _builder.append(PProblem.class, "");
                  _builder.append("(\"Inconsistent pattern definition threw exception ");
                  Class<? extends Exception> _class = e.getClass();
                  String _simpleName = _class.getSimpleName();
                  _builder.append(_simpleName, "");
                  _builder.append("  with message: ");
                  String _message = e.getMessage();
                  String _escapeToQuotedString = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.escapeToQuotedString(_message);
                  _builder.append(_escapeToQuotedString, "");
                  _builder.append("\"));");
                  _builder.newLineIfNotEmpty();
                  _builder.append("return bodies;");
                  _builder.newLine();
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client_2);
              PatternQuerySpecificationClassInferrer.this.logger.warn("Error while building PBodies", e);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        }
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "doGetContainedBodies", _typeRef_7, _function_4);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_3);
    }
    return _xblockexpression;
  }
  
  public StringConcatenationClient inferBodies(final Pattern pattern, final IQuerySpecification<?> genericSpecification) throws IllegalStateException {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          PQuery _internalQueryRepresentation = genericSpecification.getInternalQueryRepresentation();
          PDisjunction _disjunctBodies = _internalQueryRepresentation.getDisjunctBodies();
          Set<PBody> _bodies = _disjunctBodies.getBodies();
          for(final PBody pBody : _bodies) {
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("PBody body = new PBody(this);");
            _builder.newLine();
            {
              Set<PVariable> _uniqueVariables = pBody.getUniqueVariables();
              for(final PVariable variable : _uniqueVariables) {
                _builder.append("\t");
                _builder.append(PVariable.class, "\t");
                _builder.append(" ");
                String _escapedName = PatternQuerySpecificationClassInferrer.this.escapedName(variable);
                _builder.append(_escapedName, "\t");
                _builder.append(" = body.getOrCreateVariableByName(\"");
                String _name = variable.getName();
                _builder.append(_name, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("body.setExportedParameters(");
            _builder.append(Arrays.class, "\t");
            _builder.append(".<");
            _builder.append(ExportedParameter.class, "\t");
            _builder.append(">asList(");
            _builder.newLineIfNotEmpty();
            {
              List<ExportedParameter> _symbolicParameters = pBody.getSymbolicParameters();
              boolean _hasElements = false;
              for(final ExportedParameter parameter : _symbolicParameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(",\n", "\t\t");
                }
                _builder.append("\t\t");
                StringConcatenationClient _inferExportedParameterConstraint = PatternQuerySpecificationClassInferrer.this.inferExportedParameterConstraint(parameter, pBody, pattern);
                _builder.append(_inferExportedParameterConstraint, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("));");
            _builder.newLine();
            {
              Set<PConstraint> _constraints = pBody.getConstraints();
              for(final PConstraint constraint : _constraints) {
                _builder.append("\t");
                StringConcatenationClient _inferConstraint = PatternQuerySpecificationClassInferrer.this.inferConstraint(constraint, pBody, pattern);
                _builder.append(_inferConstraint, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("bodies.add(body);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
          }
        }
      }
    };
    return _client;
  }
  
  /**
   * Infers inner class for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationInnerClasses(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final boolean isPublic, final SpecificationBuilder specBuilder) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = querySpecificationClass.getMembers();
      String _querySpecificationHolderClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationHolderClassName(pattern);
      final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
        @Override
        public void apply(final JvmGenericType it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          it.setStatic(true);
          EList<JvmMember> _members = it.getMembers();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(querySpecificationClass);
          final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
            @Override
            public void apply(final JvmField it) {
              it.setFinal(true);
              it.setStatic(true);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("make()");
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _client);
            }
          };
          JvmField _field = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toField(pattern, "INSTANCE", _typeRef, _function);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
          EList<JvmMember> _members_1 = it.getMembers();
          JvmTypeReference _typeRef_1 = PatternQuerySpecificationClassInferrer.this.builder.typeRef(querySpecificationClass);
          final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              it.setVisibility(JvmVisibility.PUBLIC);
              it.setStatic(true);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("return new ");
                  String _querySpecificationClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
                  _builder.append(_querySpecificationClassName, "");
                  _builder.append("();\t\t\t\t\t");
                  _builder.newLineIfNotEmpty();
                }
              };
              PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
            }
          };
          JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(pattern, "make", _typeRef_1, _function_1);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
        }
      };
      JvmGenericType _class = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationHolderClassName, _function);
      this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members, _class);
      EList<JvmMember> _members_1 = querySpecificationClass.getMembers();
      String _querySpecificationPQueryClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationPQueryClassName(pattern);
      final Procedure1<JvmGenericType> _function_1 = new Procedure1<JvmGenericType>() {
        @Override
        public void apply(final JvmGenericType it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          it.setStatic(true);
          EList<JvmTypeReference> _superTypes = it.getSuperTypes();
          JvmTypeReference _typeRef = PatternQuerySpecificationClassInferrer.this.builder.typeRef(BaseGeneratedEMFPQuery.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
          PatternQuerySpecificationClassInferrer.this.inferPQueryMembers(it, pattern, specBuilder);
        }
      };
      JvmGenericType _class_1 = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationPQueryClassName, _function_1);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members_1, _class_1);
    }
    return _xblockexpression;
  }
  
  public String escapedName(final PVariable variable) {
    String _xifexpression = null;
    boolean _equals = Objects.equal(variable, null);
    if (_equals) {
      _xifexpression = "var_";
    } else {
      String _name = variable.getName();
      String _replaceAll = _name.replaceAll("[\\.\\{\\}<>]", "_");
      _xifexpression = ("var_" + _replaceAll);
    }
    return _xifexpression;
  }
  
  public StringConcatenationClient inferExportedParameterConstraint(final ExportedParameter constraint, final PBody body, final Pattern pattern) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("new ");
        _builder.append(ExportedParameter.class, "");
        _builder.append("(body, ");
        PVariable _parameterVariable = constraint.getParameterVariable();
        String _escapedName = PatternQuerySpecificationClassInferrer.this.escapedName(_parameterVariable);
        _builder.append(_escapedName, "");
        _builder.append(", \"");
        String _parameterName = constraint.getParameterName();
        _builder.append(_parameterName, "");
        _builder.append("\")");
      }
    };
    return _client;
  }
  
  public StringConcatenationClient inferConstraint(final PConstraint constraint, final PBody body, final Pattern pattern) {
    StringConcatenationClient _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (constraint instanceof ExportedParameter) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof Equality) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(Equality.class, "");
            _builder.append("(body, ");
            PVariable _who = ((Equality)constraint).getWho();
            String _escapedName = PatternQuerySpecificationClassInferrer.this.escapedName(_who);
            _builder.append(_escapedName, "");
            _builder.append(", ");
            PVariable _withWhom = ((Equality)constraint).getWithWhom();
            String _escapedName_1 = PatternQuerySpecificationClassInferrer.this.escapedName(_withWhom);
            _builder.append(_escapedName_1, "");
            _builder.append(");");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof Inequality) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(Inequality.class, "");
            _builder.append("(body, ");
            PVariable _who = ((Inequality)constraint).getWho();
            String _escapedName = PatternQuerySpecificationClassInferrer.this.escapedName(_who);
            _builder.append(_escapedName, "");
            _builder.append(", ");
            PVariable _withWhom = ((Inequality)constraint).getWithWhom();
            String _escapedName_1 = PatternQuerySpecificationClassInferrer.this.escapedName(_withWhom);
            _builder.append(_escapedName_1, "");
            _builder.append(");");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof TypeConstraint) {
        _matched=true;
        StringConcatenationClient _xblockexpression = null;
        {
          final IInputKey key = ((TypeConstraint)constraint).getSupplierKey();
          StringConcatenationClient _switchResult_1 = null;
          boolean _matched_1 = false;
          if (!_matched_1) {
            if (key instanceof EStructuralFeatureInstancesKey) {
              _matched_1=true;
              StringConcatenationClient _xblockexpression_1 = null;
              {
                final EStructuralFeature literal = ((EStructuralFeatureInstancesKey)key).getEmfKey();
                final EClass container = literal.getEContainingClass();
                EPackage _ePackage = container.getEPackage();
                final String packageNsUri = _ePackage.getNsURI();
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("new ");
                    _builder.append(TypeConstraint.class, "");
                    _builder.append("(body, new ");
                    _builder.append(FlatTuple.class, "");
                    _builder.append("(");
                    Tuple _variablesTuple = ((TypeConstraint)constraint).getVariablesTuple();
                    String _output = PatternQuerySpecificationClassInferrer.this.output(_variablesTuple);
                    _builder.append(_output, "");
                    _builder.append("), new ");
                    _builder.append(EStructuralFeatureInstancesKey.class, "");
                    _builder.append("(getFeatureLiteral(\"");
                    _builder.append(packageNsUri, "");
                    _builder.append("\", \"");
                    String _name = container.getName();
                    _builder.append(_name, "");
                    _builder.append("\", \"");
                    String _name_1 = literal.getName();
                    _builder.append(_name_1, "");
                    _builder.append("\")));");
                  }
                };
                _xblockexpression_1 = _client;
              }
              _switchResult_1 = _xblockexpression_1;
            }
          }
          if (!_matched_1) {
            if (key instanceof EClassTransitiveInstancesKey) {
              _matched_1=true;
              StringConcatenationClient _xblockexpression_1 = null;
              {
                final EClass literal = ((EClassTransitiveInstancesKey)key).getEmfKey();
                EPackage _ePackage = literal.getEPackage();
                final String packageNsUri = _ePackage.getNsURI();
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("new ");
                    _builder.append(TypeConstraint.class, "");
                    _builder.append("(body, new ");
                    _builder.append(FlatTuple.class, "");
                    _builder.append("(");
                    Tuple _variablesTuple = ((TypeConstraint)constraint).getVariablesTuple();
                    String _output = PatternQuerySpecificationClassInferrer.this.output(_variablesTuple);
                    _builder.append(_output, "");
                    _builder.append("), new ");
                    _builder.append(EClassTransitiveInstancesKey.class, "");
                    _builder.append("((");
                    _builder.append(EClass.class, "");
                    _builder.append(")getClassifierLiteral(\"");
                    _builder.append(packageNsUri, "");
                    _builder.append("\", \"");
                    String _name = literal.getName();
                    _builder.append(_name, "");
                    _builder.append("\")));");
                  }
                };
                _xblockexpression_1 = _client;
              }
              _switchResult_1 = _xblockexpression_1;
            }
          }
          if (!_matched_1) {
            if (key instanceof EDataTypeInSlotsKey) {
              _matched_1=true;
              StringConcatenationClient _xblockexpression_1 = null;
              {
                final EDataType literal = ((EDataTypeInSlotsKey)key).getEmfKey();
                EPackage _ePackage = literal.getEPackage();
                final String packageNsUri = _ePackage.getNsURI();
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("new ");
                    _builder.append(TypeConstraint.class, "");
                    _builder.append("(body, new ");
                    _builder.append(FlatTuple.class, "");
                    _builder.append("(");
                    Tuple _variablesTuple = ((TypeConstraint)constraint).getVariablesTuple();
                    String _output = PatternQuerySpecificationClassInferrer.this.output(_variablesTuple);
                    _builder.append(_output, "");
                    _builder.append("), new ");
                    _builder.append(EDataTypeInSlotsKey.class, "");
                    _builder.append("((");
                    _builder.append(EDataType.class, "");
                    _builder.append(")getClassifierLiteral(\"");
                    _builder.append(packageNsUri, "");
                    _builder.append("\", \"");
                    String _name = literal.getName();
                    _builder.append(_name, "");
                    _builder.append("\")));");
                  }
                };
                _xblockexpression_1 = _client;
              }
              _switchResult_1 = _xblockexpression_1;
            }
          }
          if (!_matched_1) {
            if (key instanceof JavaTransitiveInstancesKey) {
              _matched_1=true;
              StringConcatenationClient _xblockexpression_1 = null;
              {
                final Class<?> literal = ((JavaTransitiveInstancesKey)key).getEmfKey();
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("new ");
                    _builder.append(TypeConstraint.class, "");
                    _builder.append("(body, new ");
                    _builder.append(FlatTuple.class, "");
                    _builder.append("(");
                    Tuple _variablesTuple = ((TypeConstraint)constraint).getVariablesTuple();
                    String _output = PatternQuerySpecificationClassInferrer.this.output(_variablesTuple);
                    _builder.append(_output, "");
                    _builder.append("), new ");
                    _builder.append(JavaTransitiveInstancesKey.class, "");
                    _builder.append("(");
                    _builder.append(literal, "");
                    _builder.append(".class));");
                  }
                };
                _xblockexpression_1 = _client;
              }
              _switchResult_1 = _xblockexpression_1;
            }
          }
          _xblockexpression = _switchResult_1;
        }
        _switchResult = _xblockexpression;
      }
    }
    if (!_matched) {
      if (constraint instanceof ConstantValue) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(ConstantValue.class, "");
            _builder.append("(body, ");
            Tuple _variablesTuple = ((ConstantValue)constraint).getVariablesTuple();
            String _output = PatternQuerySpecificationClassInferrer.this.output(_variablesTuple);
            _builder.append(_output, "");
            _builder.append(", ");
            Object _supplierKey = ((ConstantValue)constraint).getSupplierKey();
            StringConcatenationClient _outputConstant = PatternQuerySpecificationClassInferrer.this.outputConstant(_supplierKey);
            _builder.append(_outputConstant, "");
            _builder.append(");");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof PositivePatternCall) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(PositivePatternCall.class, "");
            _builder.append("(body, new ");
            _builder.append(FlatTuple.class, "");
            _builder.append("(");
            Tuple _variablesTuple = ((PositivePatternCall)constraint).getVariablesTuple();
            String _output = PatternQuerySpecificationClassInferrer.this.output(_variablesTuple);
            _builder.append(_output, "");
            _builder.append("), ");
            PQuery _referredQuery = ((PositivePatternCall)constraint).getReferredQuery();
            StringConcatenationClient _referPQuery = PatternQuerySpecificationClassInferrer.this.referPQuery(_referredQuery, pattern);
            _builder.append(_referPQuery, "");
            _builder.append(");");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof NegativePatternCall) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(NegativePatternCall.class, "");
            _builder.append("(body, new ");
            _builder.append(FlatTuple.class, "");
            _builder.append("(");
            Tuple _actualParametersTuple = ((NegativePatternCall)constraint).getActualParametersTuple();
            String _output = PatternQuerySpecificationClassInferrer.this.output(_actualParametersTuple);
            _builder.append(_output, "");
            _builder.append("), ");
            PQuery _referredQuery = ((NegativePatternCall)constraint).getReferredQuery();
            StringConcatenationClient _referPQuery = PatternQuerySpecificationClassInferrer.this.referPQuery(_referredQuery, pattern);
            _builder.append(_referPQuery, "");
            _builder.append(");");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof BinaryTransitiveClosure) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(BinaryTransitiveClosure.class, "");
            _builder.append("(body, new ");
            _builder.append(FlatTuple.class, "");
            _builder.append("(");
            Tuple _variablesTuple = ((BinaryTransitiveClosure)constraint).getVariablesTuple();
            String _output = PatternQuerySpecificationClassInferrer.this.output(_variablesTuple);
            _builder.append(_output, "");
            _builder.append("), ");
            PQuery _supplierKey = ((BinaryTransitiveClosure)constraint).getSupplierKey();
            StringConcatenationClient _referPQuery = PatternQuerySpecificationClassInferrer.this.referPQuery(_supplierKey, pattern);
            _builder.append(_referPQuery, "");
            _builder.append(");");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof PatternMatchCounter) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(PatternMatchCounter.class, "");
            _builder.append("(body, new ");
            _builder.append(FlatTuple.class, "");
            _builder.append("(");
            Tuple _actualParametersTuple = ((PatternMatchCounter)constraint).getActualParametersTuple();
            String _output = PatternQuerySpecificationClassInferrer.this.output(_actualParametersTuple);
            _builder.append(_output, "");
            _builder.append("), ");
            PQuery _referredQuery = ((PatternMatchCounter)constraint).getReferredQuery();
            StringConcatenationClient _referPQuery = PatternQuerySpecificationClassInferrer.this.referPQuery(_referredQuery, pattern);
            _builder.append(_referPQuery, "");
            _builder.append(", ");
            PVariable _resultVariable = ((PatternMatchCounter)constraint).getResultVariable();
            String _escapedName = PatternQuerySpecificationClassInferrer.this.escapedName(_resultVariable);
            _builder.append(_escapedName, "");
            _builder.append(");");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constraint instanceof ExpressionEvaluation) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            IExpressionEvaluator _evaluator = ((ExpressionEvaluation)constraint).getEvaluator();
            final XBaseEvaluator evaluator = ((XBaseEvaluator) _evaluator);
            _builder.newLineIfNotEmpty();
            Iterable<String> _inputParameterNames = evaluator.getInputParameterNames();
            boolean _isEmpty = IterableExtensions.isEmpty(_inputParameterNames);
            if (_isEmpty) {
              XExpression _expression = evaluator.getExpression();
              PatternQuerySpecificationClassInferrer.this.feedback.reportError(_expression, "No parameters defined", EMFPatternLanguageJvmModelInferrer.SPECIFICATION_BUILDER_CODE, Severity.WARNING, IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
            }
            _builder.newLineIfNotEmpty();
            _builder.append("new ");
            _builder.append(ExpressionEvaluation.class, "");
            _builder.append("(body, new ");
            _builder.append(IExpressionEvaluator.class, "");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public String getShortDescription() {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return \"Expression evaluation from pattern ");
            String _name = pattern.getName();
            _builder.append(_name, "\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public Iterable<String> getInputParameterNames() {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return ");
            _builder.append(Arrays.class, "\t\t");
            _builder.append(".asList(");
            {
              Iterable<String> _inputParameterNames_1 = evaluator.getInputParameterNames();
              boolean _hasElements = false;
              for(final String name : _inputParameterNames_1) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "\t\t");
                }
                _builder.append("\"");
                _builder.append(name, "\t\t");
                _builder.append("\"");
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public Object evaluateExpression(");
            _builder.append(IValueProvider.class, "\t");
            _builder.append(" provider) throws Exception {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            XExpression _expression_1 = evaluator.getExpression();
            final List<Variable> variables = PatternQuerySpecificationClassInferrer.this.variables(_expression_1);
            _builder.newLineIfNotEmpty();
            {
              for(final Variable variable : variables) {
                _builder.append("\t\t\t");
                JvmTypeReference _calculateType = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                String _qualifiedName = _calculateType.getQualifiedName();
                _builder.append(_qualifiedName, "\t\t\t");
                _builder.append(" ");
                String _name_1 = variable.getName();
                _builder.append(_name_1, "\t\t\t");
                _builder.append(" = (");
                JvmTypeReference _calculateType_1 = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                String _qualifiedName_1 = _calculateType_1.getQualifiedName();
                _builder.append(_qualifiedName_1, "\t\t\t");
                _builder.append(") provider.getValue(\"");
                String _name_2 = variable.getName();
                _builder.append(_name_2, "\t\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t\t");
            _builder.append("return ");
            XExpression _expression_2 = evaluator.getExpression();
            String _expressionMethodName = PatternQuerySpecificationClassInferrer.this.expressionMethodName(_expression_2);
            _builder.append(_expressionMethodName, "\t\t\t");
            _builder.append("(");
            {
              boolean _hasElements_1 = false;
              for(final Variable variable_1 : variables) {
                if (!_hasElements_1) {
                  _hasElements_1 = true;
                } else {
                  _builder.appendImmediate(", ", "\t\t\t");
                }
                String _name_3 = variable_1.getName();
                _builder.append(_name_3, "\t\t\t");
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("}, ");
            {
              PVariable _outputVariable = ((ExpressionEvaluation)constraint).getOutputVariable();
              boolean _notEquals = (!Objects.equal(_outputVariable, null));
              if (_notEquals) {
                _builder.append(" ");
                PVariable _outputVariable_1 = ((ExpressionEvaluation)constraint).getOutputVariable();
                String _escapedName = PatternQuerySpecificationClassInferrer.this.escapedName(_outputVariable_1);
                _builder.append(_escapedName, "");
                _builder.append(" ");
              } else {
                _builder.append(" null");
              }
            }
            _builder.append("); ");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("//TODO error in code generation");
          _builder.newLine();
          _builder.append("Unsupported constraint ");
          Class<? extends PConstraint> _class = constraint.getClass();
          String _simpleName = _class.getSimpleName();
          _builder.append(_simpleName, "");
          _builder.newLineIfNotEmpty();
        }
      };
      _switchResult = _client;
    }
    return _switchResult;
  }
  
  public String output(final Tuple tuple) {
    Joiner _on = Joiner.on(", ");
    Object[] _elements = tuple.getElements();
    final Function1<Object, String> _function = new Function1<Object, String>() {
      @Override
      public String apply(final Object it) {
        return PatternQuerySpecificationClassInferrer.this.escapedName(((PVariable) it));
      }
    };
    List<String> _map = ListExtensions.<Object, String>map(((List<Object>)Conversions.doWrapArray(_elements)), _function);
    return _on.join(_map);
  }
  
  public StringConcatenationClient outputConstant(final Object constant) {
    StringConcatenationClient _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (constant instanceof EEnumLiteral) {
        _matched=true;
        StringConcatenationClient _xblockexpression = null;
        {
          final EEnum enumeration = ((EEnumLiteral)constant).getEEnum();
          final EPackage ePackage = enumeration.getEPackage();
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("getEnumLiteral(\"");
              String _nsURI = ePackage.getNsURI();
              _builder.append(_nsURI, "");
              _builder.append("\", \"");
              String _name = enumeration.getName();
              _builder.append(_name, "");
              _builder.append("\", \"");
              String _name_1 = ((EEnumLiteral)constant).getName();
              _builder.append(_name_1, "");
              _builder.append("\").getInstance()");
            }
          };
          _xblockexpression = _client;
        }
        _switchResult = _xblockexpression;
      }
    }
    if (!_matched) {
      if (constant instanceof Enumerator) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            Class<? extends Enumerator> _class = ((Enumerator)constant).getClass();
            String _canonicalName = _class.getCanonicalName();
            _builder.append(_canonicalName, "");
            _builder.append(".get(\"");
            String _literal = ((Enumerator)constant).getLiteral();
            _builder.append(_literal, "");
            _builder.append("\")");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (constant instanceof String) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("\"");
            _builder.append(((String)constant), "");
            _builder.append("\"");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(constant, "");
        }
      };
      _switchResult = _client;
    }
    return _switchResult;
  }
  
  public StringConcatenationClient referPQuery(final PQuery referredQuery, final Pattern callerPattern) {
    StringConcatenationClient _xifexpression = null;
    boolean _and = false;
    if (!(referredQuery instanceof GenericEMFPatternPQuery)) {
      _and = false;
    } else {
      Pattern _pattern = ((GenericEMFPatternPQuery) referredQuery).getPattern();
      boolean _equals = Objects.equal(_pattern, callerPattern);
      _and = _equals;
    }
    if (_and) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("this");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          JvmType _findGeneratedSpecification = PatternQuerySpecificationClassInferrer.this.findGeneratedSpecification(referredQuery);
          _builder.append(_findGeneratedSpecification, "");
          _builder.append(".instance().getInternalQueryRepresentation()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }
  
  public JvmType findGeneratedSpecification(final PQuery query) {
    if ((query instanceof GenericEMFPatternPQuery)) {
      Pattern _pattern = ((GenericEMFPatternPQuery) query).getPattern();
      return this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(_pattern);
    }
    String _fullyQualifiedName = query.getFullyQualifiedName();
    String _plus = ("Cannot find query specification for PQuery " + _fullyQualifiedName);
    throw new UnsupportedOperationException(_plus);
  }
  
  public String expressionMethodName(final XExpression ex) {
    String _expressionPostfix = this.getExpressionPostfix(ex);
    return ("evaluateExpression_" + _expressionPostfix);
  }
  
  public String getExpressionPostfix(final XExpression xExpression) {
    final Pattern pattern = EcoreUtil2.<Pattern>getContainerOfType(xExpression, Pattern.class);
    boolean _notEquals = (!Objects.equal(pattern, null));
    Preconditions.checkArgument(_notEquals, "Expression is not inside a pattern");
    int bodyNo = 0;
    EList<PatternBody> _bodies = pattern.getBodies();
    for (final PatternBody patternBody : _bodies) {
      {
        bodyNo = (bodyNo + 1);
        int exNo = 0;
        Collection<XExpression> _allTopLevelXBaseExpressions = CorePatternLanguageHelper.getAllTopLevelXBaseExpressions(patternBody);
        for (final XExpression xExpression2 : _allTopLevelXBaseExpressions) {
          {
            exNo = (exNo + 1);
            boolean _equals = xExpression.equals(xExpression2);
            if (_equals) {
              String _plus = (Integer.valueOf(bodyNo) + "_");
              return (_plus + Integer.valueOf(exNo));
            }
          }
        }
      }
    }
    throw new RuntimeException("Expression not found in pattern");
  }
  
  public List<Variable> variables(final XExpression ex) {
    List<Variable> _xblockexpression = null;
    {
      final PatternBody body = EcoreUtil2.<PatternBody>getContainerOfType(ex, PatternBody.class);
      TreeIterator<EObject> _eAllContents = ex.eAllContents();
      List<XExpression> _newImmutableList = CollectionLiterals.<XExpression>newImmutableList(ex);
      Iterator<XExpression> _iterator = _newImmutableList.iterator();
      Iterator<EObject> _plus = Iterators.<EObject>concat(_eAllContents, _iterator);
      Iterator<XFeatureCall> _filter = Iterators.<XFeatureCall>filter(_plus, XFeatureCall.class);
      final Function1<XFeatureCall, String> _function = new Function1<XFeatureCall, String>() {
        @Override
        public String apply(final XFeatureCall it) {
          return it.getConcreteSyntaxFeatureName();
        }
      };
      Iterator<String> _map = IteratorExtensions.<XFeatureCall, String>map(_filter, _function);
      final List<String> valNames = IteratorExtensions.<String>toList(_map);
      EList<Variable> _variables = body.getVariables();
      final Function1<Variable, Boolean> _function_1 = new Function1<Variable, Boolean>() {
        @Override
        public Boolean apply(final Variable it) {
          String _name = it.getName();
          return Boolean.valueOf(valNames.contains(_name));
        }
      };
      Iterable<Variable> _filter_1 = IterableExtensions.<Variable>filter(_variables, _function_1);
      final Function1<Variable, String> _function_2 = new Function1<Variable, String>() {
        @Override
        public String apply(final Variable it) {
          return it.getName();
        }
      };
      _xblockexpression = IterableExtensions.<Variable, String>sortBy(_filter_1, _function_2);
    }
    return _xblockexpression;
  }
  
  public void inferExpressions(final JvmDeclaredType querySpecificationClass, final Pattern pattern) {
    EList<PatternBody> _bodies = pattern.getBodies();
    final Function1<PatternBody, Collection<XExpression>> _function = new Function1<PatternBody, Collection<XExpression>>() {
      @Override
      public Collection<XExpression> apply(final PatternBody it) {
        return CorePatternLanguageHelper.getAllTopLevelXBaseExpressions(it);
      }
    };
    List<Collection<XExpression>> _map = ListExtensions.<PatternBody, Collection<XExpression>>map(_bodies, _function);
    Iterable<XExpression> _flatten = Iterables.<XExpression>concat(_map);
    final Procedure1<XExpression> _function_1 = new Procedure1<XExpression>() {
      @Override
      public void apply(final XExpression ex) {
        EList<JvmMember> _members = querySpecificationClass.getMembers();
        String _expressionMethodName = PatternQuerySpecificationClassInferrer.this.expressionMethodName(ex);
        JvmTypeReference _inferredType = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.inferredType(ex);
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            List<Variable> _variables = PatternQuerySpecificationClassInferrer.this.variables(ex);
            for (final Variable variable : _variables) {
              {
                String _name = variable.getName();
                JvmTypeReference _calculateType = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                final JvmFormalParameter parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _name, _calculateType);
                EList<JvmFormalParameter> _parameters = it.getParameters();
                PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, parameter);
              }
            }
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, ex);
          }
        };
        JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(ex, _expressionMethodName, _inferredType, _function);
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      }
    };
    IterableExtensions.<XExpression>forEach(_flatten, _function_1);
  }
  
  public CharSequence parameterInstantiation(final Variable variable) {
    CharSequence _xblockexpression = null;
    {
      final JvmTypeReference ref = this._iEMFTypeProvider.getVariableType(variable);
      String _xifexpression = null;
      boolean _or = false;
      boolean _equals = Objects.equal(ref, null);
      if (_equals) {
        _or = true;
      } else {
        _or = (ref instanceof JvmUnknownTypeReference);
      }
      if (_or) {
        _xifexpression = "";
      } else {
        JvmType _type = ref.getType();
        _xifexpression = _type.getQualifiedName();
      }
      final String clazz = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("new PParameter(\"");
      String _name = variable.getName();
      _builder.append(_name, "");
      _builder.append("\", \"");
      _builder.append(clazz, "");
      _builder.append("\")");
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public StringConcatenationClient inferAnnotations(final Pattern pattern, final IQuerySpecification<?> genericSpecification) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          List<PAnnotation> _allAnnotations = genericSpecification.getAllAnnotations();
          for(final PAnnotation ann : _allAnnotations) {
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(PAnnotation.class, "\t");
            _builder.append(" annotation = new ");
            _builder.append(PAnnotation.class, "\t");
            _builder.append("(\"");
            String _name = ann.getName();
            _builder.append(_name, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            {
              Collection<Map.Entry<String, Object>> _allValues = ann.getAllValues();
              for(final Map.Entry<String, Object> attribute : _allValues) {
                _builder.append("\t");
                _builder.append("annotation.addAttribute(\"");
                String _key = attribute.getKey();
                _builder.append(_key, "\t");
                _builder.append("\", ");
                Object _value = attribute.getValue();
                StringConcatenationClient _outputAnnotationParameter = PatternQuerySpecificationClassInferrer.this.outputAnnotationParameter(pattern, _value);
                _builder.append(_outputAnnotationParameter, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("addAnnotation(annotation);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    };
    return _client;
  }
  
  public StringConcatenationClient outputAnnotationParameter(final Pattern ctx, final Object value) {
    StringConcatenationClient _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (value instanceof List) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(Arrays.class, "");
            _builder.append(".asList(new Object[] {");
            _builder.newLineIfNotEmpty();
            {
              boolean _hasElements = false;
              for(final Object item : ((List<?>)value)) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "\t\t\t\t\t");
                }
                _builder.append("\t\t\t\t\t");
                StringConcatenationClient _outputAnnotationParameter = PatternQuerySpecificationClassInferrer.this.outputAnnotationParameter(ctx, item);
                _builder.append(_outputAnnotationParameter, "\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t\t\t");
            _builder.append("})");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (value instanceof ParameterReference) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(ParameterReference.class, "");
            _builder.append("(\"");
            String _name = ((ParameterReference)value).getName();
            _builder.append(_name, "");
            _builder.append("\")");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (value instanceof String) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("\"");
            _builder.append(((String)value), "");
            _builder.append("\"");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          String _string = value.toString();
          _builder.append(_string, "");
        }
      };
      _switchResult = _client;
    }
    return _switchResult;
  }
}
