/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.debug.notification;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.tooling.debug.notification.IncQueryDebugEventSetListener;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class IncQueryDebugEventSetProcessor
implements IDebugEventSetListener {
    private static IncQueryDebugEventSetProcessor instance;
    private List<IncQueryDebugEventSetListener> listeners = new LinkedList<IncQueryDebugEventSetListener>();

    public static IncQueryDebugEventSetProcessor getInstance() {
        if (instance == null) {
            instance = new IncQueryDebugEventSetProcessor();
        }
        return instance;
    }

    protected IncQueryDebugEventSetProcessor() {
    }

    public void addListener(IncQueryDebugEventSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IncQueryDebugEventSetListener listener) {
        this.listeners.remove(listener);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Object source;
            DebugEvent event = debugEventArray[n2];
            if ((event.getKind() == 2 || event.getDetail() == 8) && (source = event.getSource()) instanceof JDIThread) {
                JDIThread thread = (JDIThread)source;
                try {
                    for (IncQueryDebugEventSetListener listener : this.listeners) {
                        listener.update((JDIStackFrame)thread.getStackFrames()[0]);
                    }
                }
                catch (DebugException e) {
                    IncQueryLoggingUtil.getLogger(IncQueryDebugEventSetProcessor.class).error((Object)"Couldn't retrieve the stack frames!", (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

