/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.util.IProvider;
import org.eclipse.incquery.validation.core.api.IConstraintSpecification;
import org.eclipse.incquery.validation.core.api.IValidationEngine;
import org.eclipse.incquery.validation.runtime.ConstraintExtensionRegistry;
import org.eclipse.incquery.validation.runtime.ValidationInitializerUtil;

public final class ValidationManager {
    private ValidationManager() {
    }

    public static synchronized Multimap<String, IConstraintSpecification> getEditorConstraintSpecificationMap() {
        Multimap<String, IProvider<IConstraintSpecification>> constraintSpecificationMap = ConstraintExtensionRegistry.getEditorConstraintSpecificationMap();
        Multimap unwrappedMap = Multimaps.transformValues(constraintSpecificationMap, (Function)new Function<IProvider<IConstraintSpecification>, IConstraintSpecification>(){

            public IConstraintSpecification apply(IProvider<IConstraintSpecification> provider) {
                return (IConstraintSpecification)provider.get();
            }
        });
        return unwrappedMap;
    }

    public static synchronized boolean isConstraintSpecificationsRegisteredForEditorId(String editorId) {
        return ConstraintExtensionRegistry.isConstraintSpecificationsRegisteredForEditorId(editorId);
    }

    public static synchronized Set<IConstraintSpecification> getConstraintSpecificationsForEditorId(String editorId) {
        return ConstraintExtensionRegistry.getConstraintSpecificationsForEditorId(editorId);
    }

    public static IValidationEngine initializeValidationEngine(Notifier notifier, String editorId) throws IncQueryException {
        EMFScope scope = new EMFScope(notifier);
        return ValidationInitializerUtil.initializeValidationWithRegisteredConstraintsOnScope((IncQueryScope)scope, editorId);
    }
}

