/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.misc.DeltaMonitor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class PatternMatcherClassMethodInferrer {
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  /**
   * Infers methods for Matcher class based on the input 'pattern'.
   */
  public boolean inferMethods(final JvmDeclaredType type, final Pattern pattern, final JvmTypeReference matchClassReference) {
    boolean _xblockexpression = false;
    {
      EList<Variable> _parameters = pattern.getParameters();
      boolean _isEmpty = _parameters.isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        EList<JvmMember> _members = type.getMembers();
        JvmTypeReference _cloneWithProxies = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassReference);
        JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, Collection.class, _cloneWithProxies);
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocGetAllMatchesMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocGetAllMatchesMethod(pattern);
            String _string = _javadocGetAllMatchesMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return rawGetAllMatches(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(type, "getAllMatches", _newTypeRef, _function);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
        EList<JvmMember> _members_1 = type.getMembers();
        JvmTypeReference _cloneWithProxies_1 = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassReference);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocGetOneArbitraryMatchMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocGetOneArbitraryMatchMethod(pattern);
            String _string = _javadocGetOneArbitraryMatchMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return rawGetOneArbitraryMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(type, "getOneArbitraryMatch", _cloneWithProxies_1, _function_1);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
        EList<JvmMember> _members_2 = type.getMembers();
        JvmTypeReference _newTypeRef_1 = this._eMFJvmTypesBuilder.newTypeRef(pattern, boolean.class);
        final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocHasMatchMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocHasMatchMethod(pattern);
            String _string = _javadocHasMatchMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return rawHasMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(type, "hasMatch", _newTypeRef_1, _function_2);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
        EList<JvmMember> _members_3 = type.getMembers();
        JvmTypeReference _newTypeRef_2 = this._eMFJvmTypesBuilder.newTypeRef(pattern, int.class);
        final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocCountMatchesMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocCountMatchesMethod(pattern);
            String _string = _javadocCountMatchesMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return rawCountMatches(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(type, "countMatches", _newTypeRef_2, _function_3);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
        EList<JvmMember> _members_4 = type.getMembers();
        final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            JvmTypeReference _newTypeRef = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Void.TYPE);
            it.setReturnType(_newTypeRef);
            CharSequence _javadocForEachMatchMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocForEachMatchMethod(pattern);
            String _string = _javadocForEachMatchMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            EList<JvmFormalParameter> _parameters_2 = it.getParameters();
            JvmTypeReference _cloneWithProxies = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.cloneWithProxies(matchClassReference);
            JvmWildcardTypeReference _wildCardSuper = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.wildCardSuper(_cloneWithProxies);
            JvmTypeReference _newTypeRef_1 = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IMatchProcessor.class, _wildCardSuper);
            JvmFormalParameter _parameter_1 = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, "processor", _newTypeRef_1);
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_2, _parameter_1);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("rawForEachMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("}, processor);");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_4 = this._eMFJvmTypesBuilder.toMethod(type, "forEachMatch", null, _function_4);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_4);
        EList<JvmMember> _members_5 = type.getMembers();
        JvmTypeReference _newTypeRef_3 = this._eMFJvmTypesBuilder.newTypeRef(pattern, boolean.class);
        final Procedure1<JvmOperation> _function_5 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocForOneArbitraryMatchMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocForOneArbitraryMatchMethod(pattern);
            String _string = _javadocForOneArbitraryMatchMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            EList<JvmFormalParameter> _parameters_2 = it.getParameters();
            JvmTypeReference _cloneWithProxies = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.cloneWithProxies(matchClassReference);
            JvmWildcardTypeReference _wildCardSuper = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.wildCardSuper(_cloneWithProxies);
            JvmTypeReference _newTypeRef = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IMatchProcessor.class, _wildCardSuper);
            JvmFormalParameter _parameter_1 = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, "processor", _newTypeRef);
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_2, _parameter_1);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return rawForOneArbitraryMatch(new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("}, processor);");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_5 = this._eMFJvmTypesBuilder.toMethod(type, "forOneArbitraryMatch", _newTypeRef_3, _function_5);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_5, _method_5);
        EList<JvmMember> _members_6 = type.getMembers();
        JvmTypeReference _cloneWithProxies_2 = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassReference);
        JvmTypeReference _newTypeRef_4 = this._eMFJvmTypesBuilder.newTypeRef(pattern, DeltaMonitor.class, _cloneWithProxies_2);
        final Procedure1<JvmOperation> _function_6 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocNewFilteredDeltaMonitorMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocNewFilteredDeltaMonitorMethod(pattern);
            String _string = _javadocNewFilteredDeltaMonitorMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _newTypeRef = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, boolean.class);
            JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, "fillAtStart", _newTypeRef);
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<Variable> _parameters_1 = pattern.getParameters();
            for (final Variable parameter : _parameters_1) {
              EList<JvmFormalParameter> _parameters_2 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter_1 = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_2, _parameter_1);
            }
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toAnnotation(type, Deprecated.class);
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return rawNewFilteredDeltaMonitor(fillAtStart, new Object[]{");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append("});");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_6 = this._eMFJvmTypesBuilder.toMethod(type, "newFilteredDeltaMonitor", _newTypeRef_4, _function_6);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_6, _method_6);
        EList<JvmMember> _members_7 = type.getMembers();
        JvmTypeReference _cloneWithProxies_3 = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassReference);
        final Procedure1<JvmOperation> _function_7 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocNewMatchMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocNewMatchMethod(pattern);
            String _string = _javadocNewMatchMethod.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable parameter : _parameters) {
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
              JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
              JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, _parameterName, _calculateType);
              PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
            }
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                it.append(_builder);
                PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, matchClassReference, pattern);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(".newMatch(");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder_1.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                    _builder_1.append(_parameterName, "");
                  }
                }
                _builder_1.append(");");
                _builder_1.newLineIfNotEmpty();
                it.append(_builder_1);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_7 = this._eMFJvmTypesBuilder.toMethod(type, "newMatch", _cloneWithProxies_3, _function_7);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_7, _method_7);
        EList<Variable> _parameters_1 = pattern.getParameters();
        for (final Variable variable : _parameters_1) {
          {
            final JvmTypeReference typeOfVariable = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
            EList<JvmMember> _members_8 = type.getMembers();
            String _name = variable.getName();
            String _plus = ("rawAccumulateAllValuesOf" + _name);
            JvmTypeReference _newTypeRef_5 = this._eMFJvmTypesBuilder.newTypeRef(pattern, Set.class, typeOfVariable);
            final Procedure1<JvmOperation> _function_8 = new Procedure1<JvmOperation>() {
              public void apply(final JvmOperation it) {
                CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                String _string = _javadocGetAllValuesOfMethod.toString();
                PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                EList<JvmFormalParameter> _parameters = it.getParameters();
                JvmTypeReference _newTypeRef = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
                JvmTypeReference _addArrayTypeDimension = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_newTypeRef);
                JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, "parameters", _addArrayTypeDimension);
                PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                it.setVisibility(JvmVisibility.PROTECTED);
                final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                  public void apply(final ITreeAppendable it) {
                    PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, Set.class, typeOfVariable);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(" ");
                    _builder.append("results = new ");
                    it.append(_builder);
                    PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, HashSet.class, typeOfVariable);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("();");
                    _builder_1.newLine();
                    _builder_1.append("rawAccumulateAllValues(");
                    String _positionConstant = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(variable);
                    _builder_1.append(_positionConstant, "");
                    _builder_1.append(", parameters, results);");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("return results;");
                    it.append(_builder_1);
                  }
                };
                PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
              }
            };
            JvmOperation _method_8 = this._eMFJvmTypesBuilder.toMethod(type, _plus, _newTypeRef_5, _function_8);
            this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_8, _method_8);
            EList<JvmMember> _members_9 = type.getMembers();
            String _name_1 = variable.getName();
            String _plus_1 = ("getAllValuesOf" + _name_1);
            JvmTypeReference _newTypeRef_6 = this._eMFJvmTypesBuilder.newTypeRef(pattern, Set.class, typeOfVariable);
            final Procedure1<JvmOperation> _function_9 = new Procedure1<JvmOperation>() {
              public void apply(final JvmOperation it) {
                CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                String _string = _javadocGetAllValuesOfMethod.toString();
                PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                  public void apply(final ITreeAppendable it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("return rawAccumulateAllValuesOf");
                    String _name = variable.getName();
                    _builder.append(_name, "");
                    _builder.append("(emptyArray());");
                    it.append(_builder);
                  }
                };
                PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
              }
            };
            JvmOperation _method_9 = this._eMFJvmTypesBuilder.toMethod(type, _plus_1, _newTypeRef_6, _function_9);
            this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_9, _method_9);
            EList<Variable> _parameters_2 = pattern.getParameters();
            int _size = _parameters_2.size();
            boolean _greaterThan = (_size > 1);
            if (_greaterThan) {
              EList<JvmMember> _members_10 = type.getMembers();
              String _name_2 = variable.getName();
              String _plus_2 = ("getAllValuesOf" + _name_2);
              JvmTypeReference _newTypeRef_7 = this._eMFJvmTypesBuilder.newTypeRef(pattern, Set.class, typeOfVariable);
              final Procedure1<JvmOperation> _function_10 = new Procedure1<JvmOperation>() {
                public void apply(final JvmOperation it) {
                  CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                  String _string = _javadocGetAllValuesOfMethod.toString();
                  PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                  EList<JvmFormalParameter> _parameters = it.getParameters();
                  JvmTypeReference _cloneWithProxies = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.cloneWithProxies(matchClassReference);
                  JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(type, "partialMatch", _cloneWithProxies);
                  PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                  final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                    public void apply(final ITreeAppendable it) {
                      StringConcatenation _builder = new StringConcatenation();
                      _builder.append("return rawAccumulateAllValuesOf");
                      String _name = variable.getName();
                      _builder.append(_name, "");
                      _builder.append("(partialMatch.toArray());");
                      it.append(_builder);
                    }
                  };
                  PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
                }
              };
              JvmOperation _method_10 = this._eMFJvmTypesBuilder.toMethod(type, _plus_2, _newTypeRef_7, _function_10);
              this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_10, _method_10);
              EList<JvmMember> _members_11 = type.getMembers();
              String _name_3 = variable.getName();
              String _plus_3 = ("getAllValuesOf" + _name_3);
              JvmTypeReference _newTypeRef_8 = this._eMFJvmTypesBuilder.newTypeRef(pattern, Set.class, typeOfVariable);
              final Procedure1<JvmOperation> _function_11 = new Procedure1<JvmOperation>() {
                public void apply(final JvmOperation it) {
                  CharSequence _javadocGetAllValuesOfMethod = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocGetAllValuesOfMethod(variable);
                  String _string = _javadocGetAllValuesOfMethod.toString();
                  PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
                  EList<Variable> _parameters = pattern.getParameters();
                  for (final Variable parameter : _parameters) {
                    boolean _notEquals = (!Objects.equal(parameter, variable));
                    if (_notEquals) {
                      EList<JvmFormalParameter> _parameters_1 = it.getParameters();
                      String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(parameter);
                      JvmTypeReference _calculateType = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(parameter);
                      JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(parameter, _parameterName, _calculateType);
                      PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
                    }
                  }
                  final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                    public void apply(final ITreeAppendable it) {
                      StringConcatenation _builder = new StringConcatenation();
                      _builder.append("return rawAccumulateAllValuesOf");
                      String _name = variable.getName();
                      _builder.append(_name, "");
                      _builder.append("(new Object[]{");
                      {
                        EList<Variable> _parameters = pattern.getParameters();
                        boolean _hasElements = false;
                        for(final Variable p : _parameters) {
                          if (!_hasElements) {
                            _hasElements = true;
                          } else {
                            _builder.appendImmediate(", ", "");
                          }
                          String _xifexpression = null;
                          String _parameterName = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                          String _parameterName_1 = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                          boolean _equals = Objects.equal(_parameterName, _parameterName_1);
                          if (_equals) {
                            _xifexpression = "null";
                          } else {
                            _xifexpression = PatternMatcherClassMethodInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                          }
                          _builder.append(_xifexpression, "");
                        }
                      }
                      _builder.append("});");
                      it.append(_builder);
                    }
                  };
                  PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
                }
              };
              JvmOperation _method_11 = this._eMFJvmTypesBuilder.toMethod(type, _plus_3, _newTypeRef_8, _function_11);
              this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_11, _method_11);
            }
          }
        }
      } else {
        EList<JvmMember> _members_8 = type.getMembers();
        JvmTypeReference _newTypeRef_5 = this._eMFJvmTypesBuilder.newTypeRef(pattern, boolean.class);
        final Procedure1<JvmOperation> _function_8 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocHasMatchMethodNoParameter = PatternMatcherClassMethodInferrer.this._javadocInferrer.javadocHasMatchMethodNoParameter(pattern);
            String _string = _javadocHasMatchMethodNoParameter.toString();
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return rawHasMatch(new Object[]{});");
                it.append(_builder);
              }
            };
            PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method_8 = this._eMFJvmTypesBuilder.toMethod(type, "hasMatch", _newTypeRef_5, _function_8);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_8, _method_8);
      }
      _xblockexpression = this.inferMatcherClassToMatchMethods(type, pattern, matchClassReference);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers tupleToMatch, arrayToMatch methods for Matcher class based on the input 'pattern'.
   */
  public boolean inferMatcherClassToMatchMethods(final JvmDeclaredType matcherClass, final Pattern pattern, final JvmTypeReference matchClassRef) {
    boolean _xblockexpression = false;
    {
      JvmTypeReference _cloneWithProxies = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassRef);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toAnnotation(matcherClass, Override.class);
          PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Tuple.class);
          JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(matcherClass, "t", _newTypeRef);
          PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        }
      };
      final JvmOperation tupleToMatchMethod = this._eMFJvmTypesBuilder.toMethod(matcherClass, "tupleToMatch", _cloneWithProxies, _function);
      JvmTypeReference _cloneWithProxies_1 = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassRef);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toAnnotation(matcherClass, Override.class);
          PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
          JvmTypeReference _addArrayTypeDimension = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_newTypeRef);
          JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(matcherClass, "match", _addArrayTypeDimension);
          PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        }
      };
      final JvmOperation arrayToMatchMethod = this._eMFJvmTypesBuilder.toMethod(matcherClass, "arrayToMatch", _cloneWithProxies_1, _function_1);
      JvmTypeReference _cloneWithProxies_2 = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassRef);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toAnnotation(matcherClass, Override.class);
          PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
          JvmTypeReference _addArrayTypeDimension = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_newTypeRef);
          JvmFormalParameter _parameter = PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.toParameter(matcherClass, "match", _addArrayTypeDimension);
          PatternMatcherClassMethodInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        }
      };
      final JvmOperation arrayToMatchMutableMethod = this._eMFJvmTypesBuilder.toMethod(matcherClass, "arrayToMatchMutable", _cloneWithProxies_2, _function_2);
      final Procedure1<ITreeAppendable> _function_3 = new Procedure1<ITreeAppendable>() {
        public void apply(final ITreeAppendable it) {
          PatternMatcherClassMethodInferrer.this.inferTupleToMatchMethodBody(pattern, it);
        }
      };
      this._eMFJvmTypesBuilder.setBody(tupleToMatchMethod, _function_3);
      final Procedure1<ITreeAppendable> _function_4 = new Procedure1<ITreeAppendable>() {
        public void apply(final ITreeAppendable it) {
          PatternMatcherClassMethodInferrer.this.inferArrayToMatchMethodBody(pattern, it);
        }
      };
      this._eMFJvmTypesBuilder.setBody(arrayToMatchMethod, _function_4);
      final Procedure1<ITreeAppendable> _function_5 = new Procedure1<ITreeAppendable>() {
        public void apply(final ITreeAppendable it) {
          PatternMatcherClassMethodInferrer.this.inferArrayToMatchMutableMethodBody(pattern, it);
        }
      };
      this._eMFJvmTypesBuilder.setBody(arrayToMatchMutableMethod, _function_5);
      EList<JvmMember> _members = matcherClass.getMembers();
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, tupleToMatchMethod);
      EList<JvmMember> _members_1 = matcherClass.getMembers();
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, arrayToMatchMethod);
      EList<JvmMember> _members_2 = matcherClass.getMembers();
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, arrayToMatchMutableMethod);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers the tupleToMatch method body.
   */
  public ITreeAppendable inferTupleToMatchMethodBody(final Pattern pattern, final ITreeAppendable appendable) {
    ITreeAppendable _xblockexpression = null;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("try {");
      _builder.newLine();
      _builder.append("  ");
      _builder.append("return ");
      String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
      _builder.append(_matchClassName, "  ");
      _builder.append(".newMatch(");
      {
        EList<Variable> _parameters = pattern.getParameters();
        boolean _hasElements = false;
        for(final Variable p : _parameters) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(", ", "  ");
          }
          _builder.append("(");
          JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
          String _qualifiedName = _calculateType.getQualifiedName();
          _builder.append(_qualifiedName, "  ");
          _builder.append(") t.get(");
          String _positionConstant = this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(p);
          _builder.append(_positionConstant, "  ");
          _builder.append(")");
        }
      }
      _builder.append(");");
      _builder.newLineIfNotEmpty();
      _builder.append("} catch(ClassCastException e) {");
      appendable.append(_builder);
      appendable.increaseIndentation();
      this.inferErrorLogging("Element(s) in tuple not properly typed!", "e", appendable);
      appendable.decreaseIndentation();
      appendable.newLine();
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("  ");
      _builder_1.append("return null;");
      _builder_1.newLine();
      _builder_1.append("}");
      _builder_1.newLine();
      _xblockexpression = appendable.append(_builder_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers the arrayToMatch method body.
   */
  public ITreeAppendable inferArrayToMatchMethodBody(final Pattern pattern, final ITreeAppendable appendable) {
    ITreeAppendable _xblockexpression = null;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("try {");
      _builder.newLine();
      _builder.append("  ");
      _builder.append("return ");
      String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
      _builder.append(_matchClassName, "  ");
      _builder.append(".newMatch(");
      {
        EList<Variable> _parameters = pattern.getParameters();
        boolean _hasElements = false;
        for(final Variable p : _parameters) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(", ", "  ");
          }
          _builder.append("(");
          JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
          String _qualifiedName = _calculateType.getQualifiedName();
          _builder.append(_qualifiedName, "  ");
          _builder.append(") match[");
          String _positionConstant = this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(p);
          _builder.append(_positionConstant, "  ");
          _builder.append("]");
        }
      }
      _builder.append(");");
      _builder.newLineIfNotEmpty();
      _builder.append("} catch(ClassCastException e) {");
      appendable.append(_builder);
      appendable.increaseIndentation();
      this.inferErrorLogging("Element(s) in array not properly typed!", "e", appendable);
      appendable.decreaseIndentation();
      appendable.newLine();
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("  ");
      _builder_1.append("return null;");
      _builder_1.newLine();
      _builder_1.append("}");
      _builder_1.newLine();
      _xblockexpression = appendable.append(_builder_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers the arrayToMatch method body.
   */
  public ITreeAppendable inferArrayToMatchMutableMethodBody(final Pattern pattern, final ITreeAppendable appendable) {
    ITreeAppendable _xblockexpression = null;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("try {");
      _builder.newLine();
      _builder.append("  ");
      _builder.append("return ");
      String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
      _builder.append(_matchClassName, "  ");
      _builder.append(".newMutableMatch(");
      {
        EList<Variable> _parameters = pattern.getParameters();
        boolean _hasElements = false;
        for(final Variable p : _parameters) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(", ", "  ");
          }
          _builder.append("(");
          JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
          String _qualifiedName = _calculateType.getQualifiedName();
          _builder.append(_qualifiedName, "  ");
          _builder.append(") match[");
          String _positionConstant = this._eMFPatternLanguageJvmModelInferrerUtil.positionConstant(p);
          _builder.append(_positionConstant, "  ");
          _builder.append("]");
        }
      }
      _builder.append(");");
      _builder.newLineIfNotEmpty();
      _builder.append("} catch(ClassCastException e) {");
      appendable.append(_builder);
      appendable.increaseIndentation();
      this.inferErrorLogging("Element(s) in array not properly typed!", "e", appendable);
      appendable.decreaseIndentation();
      appendable.newLine();
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("  ");
      _builder_1.append("return null;");
      _builder_1.newLine();
      _builder_1.append("}");
      _builder_1.newLine();
      _xblockexpression = appendable.append(_builder_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers the appropriate logging based on the parameters.
   */
  public ITreeAppendable inferErrorLogging(final String message, final String exceptionName, final ITreeAppendable appendable) {
    ITreeAppendable _xblockexpression = null;
    {
      appendable.newLine();
      ITreeAppendable _xifexpression = null;
      boolean _equals = Objects.equal(exceptionName, null);
      if (_equals) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("LOGGER.error(\"");
        _builder.append(message, "");
        _builder.append("\");");
        _xifexpression = appendable.append(_builder);
      } else {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("LOGGER.error(\"");
        _builder_1.append(message, "");
        _builder_1.append("\",");
        _builder_1.append(exceptionName, "");
        _builder_1.append(");");
        _xifexpression = appendable.append(_builder_1);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
