/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.ui.contentassist;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.annotations.PatternAnnotationProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.ui.contentassist.AbstractPatternLanguageProposalProvider;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.ui.contentassist.XbaseProposalProvider;

public class PatternLanguageProposalProvider
extends AbstractPatternLanguageProposalProvider {
    @Inject
    private PatternAnnotationProvider annotationProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private AbstractJavaBasedContentProposalProvider.ReferenceProposalCreator crossReferenceProposalCreator;
    @Inject
    private XbaseProposalProvider.ValidFeatureDescription featureDescriptionPredicate;

    @Override
    public void complete_Annotation(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (String annotationName : this.annotationProvider.getAllAnnotationNames()) {
            ICompletionProposal proposal;
            if (this.annotationProvider.isDeprecated(annotationName)) continue;
            String prefixedName = String.format("@%s", annotationName);
            String prefix = context.getPrefix();
            ContentAssistContext modifiedContext = context;
            INode lastNode = context.getLastCompleteNode();
            if ("".equals(prefix) && lastNode.getSemanticElement() instanceof Annotation) {
                Annotation previousNode = (Annotation)lastNode.getSemanticElement();
                String annotationPrefix = previousNode.getName();
                if (previousNode.getParameters().isEmpty() && !this.annotationProvider.getAllAnnotationNames().contains(annotationPrefix)) {
                    modifiedContext = context.copy().setReplaceRegion(new Region(lastNode.getOffset(), lastNode.getLength() + prefix.length())).toContext();
                    prefixedName = annotationName;
                }
            }
            if ((proposal = this.createCompletionProposal(prefixedName, prefixedName, null, modifiedContext)) instanceof ConfigurableCompletionProposal) {
                ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)this.annotationProvider.getAnnotationObject(annotationName));
                ((ConfigurableCompletionProposal)proposal).setHover(this.getHover());
            }
            acceptor.accept(proposal);
        }
    }

    @Override
    public void complete_AnnotationParameter(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof Annotation) {
            Annotation annotation = (Annotation)model;
            for (String paramName : this.annotationProvider.getAnnotationParameters(annotation.getName())) {
                String outputName = String.format("%s = ", paramName);
                ICompletionProposal proposal = this.createCompletionProposal(outputName, paramName, null, context);
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)this.annotationProvider.getAnnotationParameter(annotation.getName(), paramName));
                    ((ConfigurableCompletionProposal)proposal).setHover(this.getHover());
                }
                acceptor.accept(proposal);
            }
        }
    }

    @Override
    public void complete_VariableReference(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IScope scope = this.scopeProvider.getScope(model, PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VARIABLE);
        this.crossReferenceProposalCreator.lookupCrossReference(scope, model, PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VARIABLE, acceptor, Predicates.alwaysTrue(), this.getProposalFactory(ruleCall.getRule().getName(), context));
    }

    protected void createLocalVariableAndImplicitProposals(EObject context, IExpressionScope.Anchor anchor, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        String prefix = contentAssistContext.getPrefix();
        if (prefix.length() > 0 && !Character.isJavaIdentifierStart(prefix.charAt(0))) {
            return;
        }
        PatternBody body = (PatternBody)EcoreUtil2.getContainerOfType((EObject)context, PatternBody.class);
        for (Variable v : body.getVariables()) {
            if (v.getName().startsWith("_")) continue;
            ICompletionProposal proposal = this.createCompletionProposal(v.getName(), contentAssistContext);
            acceptor.accept(proposal);
        }
        this.getProposalFactory(this.getFeatureCallRuleName(), contentAssistContext);
        this.proposeDeclaringTypeForStaticInvocation(context, null, contentAssistContext, acceptor);
    }

    @Override
    public void completePatternCall_PatternRef(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference((CrossReference)assignment.getTerminal(), context, acceptor, Predicates.and((Predicate)this.featureDescriptionPredicate, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return !"true".equals(input.getUserData("private"));
            }
        }));
    }
}

