/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.querybasedfeatures.runtime.IQueryBasedFeatureHandler;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureInverter;

public class InvertableQueryBasedEList<ComputedType, StorageType>
extends AbstractEList<ComputedType> {
    private EList<StorageType> storageEList;
    private EObject sourceObject;
    private IQueryBasedFeatureHandler handler;
    private QueryBasedFeatureInverter<ComputedType, StorageType> inverter;

    public InvertableQueryBasedEList(EObject sourceObject, EList<StorageType> storageEList, IQueryBasedFeatureHandler handler, QueryBasedFeatureInverter<ComputedType, StorageType> inverter) {
        this.storageEList = storageEList;
        this.sourceObject = sourceObject;
        this.handler = handler;
        this.inverter = inverter;
    }

    protected ComputedType validate(int index, ComputedType object) {
        Object s = super.validate(index, object);
        return (ComputedType)this.inverter.validate(s);
    }

    protected ComputedType primitiveGet(int index) {
        Object t = this.storageEList.get(index);
        List<?> values = this.handler.getManyReferenceValue(this.sourceObject);
        for (Object object : values) {
            if (!this.inverter.invert(object).equals(t)) continue;
            return (ComputedType)object;
        }
        return null;
    }

    public ComputedType setUnique(int index, ComputedType object) {
        ComputedType source = this.get(index);
        StorageType newTarget = this.inverter.invert(object);
        this.storageEList.set(index, newTarget);
        return source;
    }

    public void addUnique(ComputedType object) {
        StorageType newTarget = this.inverter.invert(object);
        this.storageEList.add(newTarget);
    }

    public void addUnique(int index, ComputedType object) {
        StorageType newTarget = this.inverter.invert(object);
        this.storageEList.add(index, newTarget);
    }

    public boolean addAllUnique(Collection<? extends ComputedType> collection) {
        boolean hasChanged = false;
        for (ComputedType source : collection) {
            StorageType newTarget = this.inverter.invert(source);
            hasChanged |= this.storageEList.add(newTarget);
        }
        return hasChanged;
    }

    public boolean addAllUnique(int index, Collection<? extends ComputedType> collection) {
        int oldSize = this.storageEList.size();
        int tempIndex = index;
        for (ComputedType source : collection) {
            StorageType newTarget = this.inverter.invert(source);
            this.storageEList.add(tempIndex, newTarget);
            ++tempIndex;
        }
        return oldSize < this.storageEList.size();
    }

    public boolean addAllUnique(Object[] objects, int start, int end) {
        boolean hasChanged = false;
        int i = start;
        while (i <= end) {
            StorageType newTarget = this.inverter.invert(objects[i]);
            hasChanged |= this.storageEList.add(newTarget);
            ++i;
        }
        return hasChanged;
    }

    public boolean addAllUnique(int index, Object[] objects, int start, int end) {
        int oldSize = this.storageEList.size();
        int tempIndex = index;
        int i = start;
        while (i <= end) {
            StorageType newTarget = this.inverter.invert(objects[i]);
            this.storageEList.add(tempIndex, newTarget);
            ++tempIndex;
            ++i;
        }
        return oldSize < this.storageEList.size();
    }

    public ComputedType remove(int index) {
        ComputedType source = this.get(index);
        StorageType target = this.inverter.invert(source);
        this.storageEList.remove(target);
        return source;
    }

    public ComputedType move(int targetIndex, int sourceIndex) {
        ComputedType tSource = this.get(sourceIndex);
        StorageType tTarget = this.inverter.invert(tSource);
        this.storageEList.move(targetIndex, tTarget);
        return tSource;
    }

    protected List<ComputedType> basicList() {
        return this.handler.getManyReferenceValue(this.sourceObject);
    }

    public ComputedType get(int index) {
        return (ComputedType)this.basicGet(index);
    }

    public int size() {
        return this.handler.getManyReferenceValue(this.sourceObject).size();
    }
}

