/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.incquery.runtime.base.api.BaseIndexOptions;
import org.eclipse.incquery.runtime.base.api.DataTypeListener;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.InstanceListener;
import org.eclipse.incquery.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.incquery.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.incquery.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.incquery.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.base.core.NavigationHelperImpl;
import org.eclipse.incquery.runtime.base.core.NavigationHelperVisitor;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;

public class NavigationHelperContentAdapter
extends EContentAdapter {
    private static final EClass EOBJECT_CLASS = EcorePackage.eINSTANCE.getEObject();
    private final NavigationHelperImpl navigationHelper;
    private boolean isDirty = false;
    private final Table<Object, Object, Set<EObject>> valueToFeatureToHolderMap;
    private Map<Object, Multiset<EObject>> featureToHolderMap;
    private Table<EObject, Object, Set<Object>> holderToFeatureToValueMap;
    private final Map<Object, Set<EObject>> instanceMap;
    private final Map<Object, Map<Object, Integer>> dataTypeMap;
    private final Set<EClassifier> knownClassifiers = new HashSet<EClassifier>();
    private final Set<EStructuralFeature> knownFeatures = new HashSet<EStructuralFeature>();
    private final Map<Object, Set<Object>> subTypeMap = new HashMap<Object, Set<Object>>();
    private final Map<Object, Set<Object>> superTypeMap = new HashMap<Object, Set<Object>>();
    private final Multimap<String, EPackage> uniqueIDToPackage = HashMultimap.create();
    private final Map<EClassifier, String> uniqueIDFromClassifier = new HashMap<EClassifier, String>();
    private final Map<ETypedElement, String> uniqueIDFromTypedElement = new HashMap<ETypedElement, String>();
    private final Multimap<String, EClassifier> uniqueIDToClassifier = HashMultimap.create((int)100, (int)1);
    private final Multimap<String, ETypedElement> uniqueIDToTypedElement = HashMultimap.create((int)100, (int)1);
    private Object eObjectClassKey = null;
    protected EObject ignoreInsertionAndDeletion;
    private final EMFModelComprehension comprehension;
    private final boolean isDynamicModel;
    private IBaseIndexObjectFilter objectFilterConfiguration;
    private IBaseIndexResourceFilter resourceFilterConfiguration;

    public NavigationHelperContentAdapter(NavigationHelperImpl navigationHelper) {
        this.navigationHelper = navigationHelper;
        BaseIndexOptions options = this.navigationHelper.getBaseIndexOptions();
        this.objectFilterConfiguration = options.getObjectFilterConfiguration();
        this.resourceFilterConfiguration = options.getResourceFilterConfiguration();
        this.comprehension = navigationHelper.getComprehension();
        this.isDynamicModel = navigationHelper.getBaseIndexOptions().isDynamicEMFMode();
        this.valueToFeatureToHolderMap = HashBasedTable.create();
        this.instanceMap = new HashMap<Object, Set<EObject>>();
        this.dataTypeMap = new HashMap<Object, Map<Object, Integer>>();
    }

    public Object getEObjectClassKey() {
        if (this.eObjectClassKey == null) {
            this.eObjectClassKey = this.toKey((EClassifier)EOBJECT_CLASS);
        }
        return this.eObjectClassKey;
    }

    protected Object toKey(EClassifier classifier) {
        if (this.isDynamicModel) {
            return this.toKeyDynamicInternal(classifier);
        }
        this.maintainMetamodel(classifier);
        return classifier;
    }

    private String toKeyDynamicInternal(EClassifier classifier) {
        String id = this.uniqueIDFromClassifier.get(classifier);
        if (id == null) {
            Preconditions.checkArgument((!classifier.eIsProxy() ? 1 : 0) != 0, (Object)String.format("Classifier %s is an unresolved proxy", classifier));
            id = String.valueOf(classifier.getEPackage().getNsURI()) + "##" + classifier.getName();
            this.uniqueIDFromClassifier.put(classifier, id);
            this.uniqueIDToClassifier.put((Object)id, (Object)classifier);
            this.maintainMetamodel(classifier);
        }
        return id;
    }

    protected Object toKey(EStructuralFeature feature) {
        if (this.isDynamicModel) {
            String id = this.uniqueIDFromTypedElement.get(feature);
            if (id == null) {
                Preconditions.checkArgument((!feature.eIsProxy() ? 1 : 0) != 0, (Object)String.format("Element %s is an unresolved proxy", feature));
                id = String.valueOf(this.toKeyDynamicInternal((EClassifier)feature.eContainer())) + "##" + feature.getEType().getName() + "##" + feature.getName();
                this.uniqueIDFromTypedElement.put((ETypedElement)feature, id);
                this.uniqueIDToTypedElement.put((Object)id, (Object)feature);
                this.maintainMetamodel(feature);
            }
            return id;
        }
        this.maintainMetamodel(feature);
        return feature;
    }

    public void notifyChanged(final Notification notification) {
        try {
            this.navigationHelper.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    NavigationHelperContentAdapter.super.notifyChanged(notification);
                    Object oFeature = notification.getFeature();
                    Object oNotifier = notification.getNotifier();
                    if (oNotifier instanceof EObject && oFeature instanceof EStructuralFeature) {
                        EObject notifier = (EObject)oNotifier;
                        EStructuralFeature feature = (EStructuralFeature)oFeature;
                        boolean notifyLightweightObservers = NavigationHelperContentAdapter.this.handleNotification(notification, notifier, feature);
                        if (notifyLightweightObservers) {
                            NavigationHelperContentAdapter.this.notifyLightweightObservers(notifier, feature, notification);
                        }
                    } else if (oNotifier instanceof Resource && notification.getFeatureID(Resource.class) == 4) {
                        Resource resource = (Resource)oNotifier;
                        if (NavigationHelperContentAdapter.this.comprehension.isLoading(resource)) {
                            ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.add(resource);
                        } else {
                            ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.remove(resource);
                        }
                    }
                    return null;
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.processingFatal(ex.getCause(), "handling the following update notification: " + notification);
        }
        catch (Exception ex) {
            this.processingFatal(ex, "handling the following update notification: " + notification);
        }
        this.notifyBaseIndexChangeListeners();
    }

    private boolean handleNotification(Notification notification, EObject notifier, EStructuralFeature feature) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        int positionInt = notification.getPosition();
        Integer position = positionInt == -1 ? null : Integer.valueOf(positionInt);
        int eventType = notification.getEventType();
        boolean notifyLightweightObservers = false;
        switch (eventType) {
            case 3: {
                this.featureUpdate(true, notifier, feature, newValue, position);
                notifyLightweightObservers = true;
                break;
            }
            case 5: {
                for (Object newElement : (Collection)newValue) {
                    this.featureUpdate(true, notifier, feature, newElement, position);
                }
                notifyLightweightObservers = true;
                break;
            }
            case 0: {
                break;
            }
            case 7: {
                break;
            }
            case 4: {
                this.featureUpdate(false, notifier, feature, oldValue, position);
                notifyLightweightObservers = true;
                break;
            }
            case 6: {
                for (Object oldElement : (Collection)oldValue) {
                    this.featureUpdate(false, notifier, feature, oldElement, position);
                }
                notifyLightweightObservers = true;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (this.navigationHelper.isFeatureResolveIgnored(feature)) break;
                if (!feature.isMany()) {
                    this.navigationHelper.delayedProxyResolutions.remove((Object)notifier, (Object)feature);
                }
            }
            case 1: 
            case 2: {
                this.featureUpdate(false, notifier, feature, oldValue, position);
                this.featureUpdate(true, notifier, feature, newValue, position);
                notifyLightweightObservers = true;
            }
        }
        return notifyLightweightObservers;
    }

    protected void notifyBaseIndexChangeListeners() {
        this.navigationHelper.notifyBaseIndexChangeListeners(this.isDirty);
        if (this.isDirty) {
            this.isDirty = false;
        }
    }

    private void featureUpdate(boolean isInsertion, EObject notifier, EStructuralFeature feature, Object value, Integer position) {
        this.comprehension.traverseFeature(this.visitor(isInsertion), notifier, feature, value, position);
    }

    protected void addAdapter(final Notifier notifier) {
        if (notifier == this.ignoreInsertionAndDeletion) {
            return;
        }
        try {
            this.navigationHelper.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (notifier instanceof EObject) {
                        NavigationHelperContentAdapter.this.comprehension.traverseObject(NavigationHelperContentAdapter.this.visitor(true), (EObject)notifier);
                    } else if (notifier instanceof Resource) {
                        Resource resource = (Resource)notifier;
                        if (NavigationHelperContentAdapter.this.comprehension.isLoading(resource)) {
                            ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.add(resource);
                        }
                    }
                    NavigationHelperContentAdapter.super.addAdapter(notifier);
                    return null;
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.processingFatal(ex.getCause(), "add the object: " + notifier);
        }
        catch (Exception ex) {
            this.processingFatal(ex, "add the object: " + notifier);
        }
    }

    protected void removeAdapter(final Notifier notifier) {
        if (notifier == this.ignoreInsertionAndDeletion) {
            return;
        }
        try {
            this.navigationHelper.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (notifier instanceof EObject) {
                        EObject eObject = (EObject)notifier;
                        NavigationHelperContentAdapter.this.comprehension.traverseObject(NavigationHelperContentAdapter.this.visitor(false), eObject);
                        ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.delayedProxyResolutions.removeAll((Object)eObject);
                    } else if (notifier instanceof Resource) {
                        ((NavigationHelperContentAdapter)NavigationHelperContentAdapter.this).navigationHelper.resolutionDelayingResources.remove(notifier);
                    }
                    NavigationHelperContentAdapter.super.removeAdapter(notifier);
                    return null;
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.processingFatal(ex.getCause(), "remove the object: " + notifier);
        }
        catch (Exception ex) {
            this.processingFatal(ex, "remove the object: " + notifier);
        }
    }

    protected void processingFatal(Throwable ex, String task) {
        this.navigationHelper.notifyFatalListener(this.logTaskFormat(task), ex);
    }

    protected void processingError(Throwable ex, String task) {
        this.navigationHelper.notifyErrorListener(this.logTaskFormat(task), ex);
    }

    private String logTaskFormat(String task) {
        return "EMF-IncQuery encountered an error in processing the EMF model. This happened while trying to " + task;
    }

    protected EMFVisitor visitor(boolean isInsertion) {
        return new NavigationHelperVisitor.ChangeVisitor(this.navigationHelper, isInsertion);
    }

    private void addToFeatureMap(Object featureKey, Object value, EObject holder) {
        HashSet<EObject> setVal = (HashSet<EObject>)this.valueToFeatureToHolderMap.get(value, featureKey);
        if (setVal == null) {
            setVal = new HashSet<EObject>();
            this.valueToFeatureToHolderMap.put(value, featureKey, setVal);
        }
        setVal.add(holder);
    }

    private void addToReversedFeatureMap(Object feature, EObject holder) {
        HashMultiset setVal = this.featureToHolderMap.get(feature);
        if (setVal == null) {
            setVal = HashMultiset.create();
            this.featureToHolderMap.put(feature, (Multiset<EObject>)setVal);
        }
        setVal.add((Object)holder);
    }

    private void addToDirectFeatureMap(EObject holder, Object feature, Object value) {
        HashSet<Object> setVal = (HashSet<Object>)this.holderToFeatureToValueMap.get((Object)holder, feature);
        if (setVal == null) {
            setVal = new HashSet<Object>();
            this.holderToFeatureToValueMap.put((Object)holder, feature, setVal);
        }
        setVal.add(value);
    }

    private void removeFromReversedFeatureMap(Object feature, EObject holder) {
        Multiset<EObject> setVal = this.featureToHolderMap.get(feature);
        if (setVal != null) {
            setVal.remove((Object)holder);
            if (setVal.isEmpty()) {
                this.featureToHolderMap.remove(feature);
            }
        }
    }

    private void removeFromFeatureMap(Object featureKey, Object value, EObject holder) {
        Set setHolder = (Set)this.valueToFeatureToHolderMap.get(value, featureKey);
        if (setHolder != null) {
            setHolder.remove(holder);
            if (setHolder.isEmpty()) {
                this.valueToFeatureToHolderMap.remove(value, featureKey);
            }
        }
    }

    private void removeFromDirectFeatureMap(EObject holder, Object feature, Object value) {
        Set setVal = (Set)this.holderToFeatureToValueMap.get((Object)holder, feature);
        if (setVal != null) {
            setVal.remove(value);
            if (setVal.isEmpty()) {
                this.valueToFeatureToHolderMap.remove((Object)holder, feature);
            }
        }
    }

    public void insertFeatureTuple(Object featureKey, Object value, EObject holder) {
        this.addToFeatureMap(featureKey, value, holder);
        if (this.featureToHolderMap != null) {
            this.addToReversedFeatureMap(featureKey, holder);
        }
        if (this.holderToFeatureToValueMap != null) {
            this.addToDirectFeatureMap(holder, featureKey, value);
        }
        this.isDirty = true;
        this.notifyFeatureListeners(holder, featureKey, value, true);
    }

    public void removeFeatureTuple(Object featureKey, Object value, EObject holder) {
        this.removeFromFeatureMap(featureKey, value, holder);
        if (this.featureToHolderMap != null) {
            this.removeFromReversedFeatureMap(featureKey, holder);
        }
        if (this.holderToFeatureToValueMap != null) {
            this.removeFromDirectFeatureMap(holder, featureKey, value);
        }
        this.isDirty = true;
        this.notifyFeatureListeners(holder, featureKey, value, false);
    }

    public Set<EObject> getInstanceSet(Object keyClass) {
        return this.instanceMap.get(keyClass);
    }

    public void removeInstanceSet(Object keyClass) {
        this.instanceMap.remove(keyClass);
    }

    public void insertIntoInstanceSet(Object keyClass, EObject value) {
        Set<EObject> set = this.instanceMap.get(keyClass);
        if (set == null) {
            set = new HashSet<EObject>();
            this.instanceMap.put(keyClass, set);
        }
        set.add(value);
        this.isDirty = true;
        this.notifyInstanceListeners(keyClass, value, true);
    }

    public void removeFromInstanceSet(Object keyClass, EObject value) {
        Set<EObject> set = this.instanceMap.get(keyClass);
        if (set != null) {
            set.remove(value);
            if (set.isEmpty()) {
                this.instanceMap.remove(keyClass);
            }
        }
        this.isDirty = true;
        this.notifyInstanceListeners(keyClass, value, false);
    }

    public Map<Object, Integer> getDataTypeMap(Object keyType) {
        return this.dataTypeMap.get(keyType);
    }

    public void removeDataTypeMap(Object keyType) {
        this.dataTypeMap.remove(keyType);
    }

    public void insertIntoDataTypeMap(Object keyType, Object value) {
        boolean firstOccurrence;
        Map<Object, Integer> valMap = this.dataTypeMap.get(keyType);
        if (valMap == null) {
            valMap = new HashMap<Object, Integer>();
            this.dataTypeMap.put(keyType, valMap);
        }
        boolean bl = firstOccurrence = valMap.get(value) == null;
        if (firstOccurrence) {
            valMap.put(value, 1);
        } else {
            Integer count = valMap.get(value);
            count = count + 1;
            valMap.put(value, count);
        }
        this.isDirty = true;
        this.notifyDataTypeListeners(keyType, value, true, firstOccurrence);
    }

    public void removeFromDataTypeMap(Object keyType, Object value) {
        Map<Object, Integer> valMap = this.dataTypeMap.get(keyType);
        if (valMap != null && valMap.get(value) != null) {
            boolean lastOccurrence;
            Integer count = valMap.get(value);
            boolean bl = lastOccurrence = (count = Integer.valueOf(count - 1)) == 0;
            if (lastOccurrence) {
                valMap.remove(value);
                if (valMap.size() == 0) {
                    this.dataTypeMap.remove(keyType);
                }
            } else {
                valMap.put(value, count);
            }
            this.isDirty = true;
            this.notifyDataTypeListeners(keyType, value, false, lastOccurrence);
        }
    }

    protected void maintainMetamodel(EStructuralFeature feature) {
        if (!this.knownFeatures.contains(feature)) {
            this.knownFeatures.add(feature);
            this.maintainMetamodel((EClassifier)feature.getEContainingClass());
            this.maintainMetamodel(feature.getEType());
        }
    }

    protected void maintainMetamodel(EClassifier classifier) {
        if (!this.knownClassifiers.contains(classifier)) {
            this.checkEPackage(classifier);
            this.knownClassifiers.add(classifier);
            if (classifier instanceof EClass) {
                EClass clazz = (EClass)classifier;
                Object clazzKey = this.toKey((EClassifier)clazz);
                for (EClass superType : clazz.getEAllSuperTypes()) {
                    this.maintainTypeHierarhyInternal(clazzKey, this.toKey((EClassifier)superType));
                }
                this.maintainTypeHierarhyInternal(clazzKey, this.getEObjectClassKey());
            }
        }
    }

    private void checkEPackage(EClassifier classifier) {
        EPackage ePackage = classifier.getEPackage();
        String nsURI = ePackage.getNsURI();
        Collection packagesOfURI = this.uniqueIDToPackage.get((Object)nsURI);
        if (!packagesOfURI.contains(ePackage)) {
            this.uniqueIDToPackage.put((Object)nsURI, (Object)ePackage);
            if (!this.isDynamicModel && packagesOfURI.size() == 2) {
                this.processingError(new IncQueryBaseException("NsURI (" + nsURI + ") collision detected between different instances of EPackages. If this is normal, try using dynamic EMF mode."), "process new metamodel elements.");
            }
        }
    }

    private void maintainTypeHierarhyInternal(Object subClassKey, Object superClassKey) {
        Set<Object> subTypes;
        Table<Object, InstanceListener, Set<EClass>> instanceListeners;
        if (this.navigationHelper.directlyObservedClasses.contains(superClassKey)) {
            this.navigationHelper.getAllObservedClassesInternal().add(subClassKey);
        }
        if ((instanceListeners = this.navigationHelper.peekInstanceListeners()) != null) {
            for (Map.Entry entry : instanceListeners.row(superClassKey).entrySet()) {
                InstanceListener listener = (InstanceListener)entry.getKey();
                for (EClass subscriptionType : (Set)entry.getValue()) {
                    this.navigationHelper.addInstanceListenerInternal(listener, subscriptionType, subClassKey);
                }
            }
        }
        if ((subTypes = this.subTypeMap.get(superClassKey)) == null) {
            subTypes = new HashSet<Object>();
            this.subTypeMap.put(superClassKey, subTypes);
        }
        subTypes.add(subClassKey);
        Set<Object> superTypes = this.superTypeMap.get(subClassKey);
        if (superTypes == null) {
            superTypes = new HashSet<Object>();
            this.superTypeMap.put(subClassKey, superTypes);
        }
        superTypes.add(superClassKey);
    }

    private void notifyDataTypeListeners(Object typeKey, Object value, boolean isInsertion, boolean firstOrLastOccurrence) {
        for (Map.Entry entry : this.navigationHelper.getDataTypeListeners().row(typeKey).entrySet()) {
            DataTypeListener listener = (DataTypeListener)entry.getKey();
            for (EDataType subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.dataTypeInstanceInserted(subscriptionType, value, firstOrLastOccurrence);
                    continue;
                }
                listener.dataTypeInstanceDeleted(subscriptionType, value, firstOrLastOccurrence);
            }
        }
    }

    private void notifyFeatureListeners(EObject host, Object featureKey, Object value, boolean isInsertion) {
        for (Map.Entry entry : this.navigationHelper.getFeatureListeners().row(featureKey).entrySet()) {
            FeatureListener listener = (FeatureListener)entry.getKey();
            for (EStructuralFeature subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.featureInserted(host, subscriptionType, value);
                    continue;
                }
                listener.featureDeleted(host, subscriptionType, value);
            }
        }
    }

    private void notifyInstanceListeners(Object clazzKey, EObject instance, boolean isInsertion) {
        for (Map.Entry entry : this.navigationHelper.getInstanceListeners().row(clazzKey).entrySet()) {
            InstanceListener listener = (InstanceListener)entry.getKey();
            for (EClass subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.instanceInserted(subscriptionType, instance);
                    continue;
                }
                listener.instanceDeleted(subscriptionType, instance);
            }
        }
    }

    private void notifyLightweightObservers(EObject host, EStructuralFeature feature, Notification notification) {
        for (Map.Entry<LightweightEObjectObserver, Collection<EObject>> entry : this.navigationHelper.getLightweightObservers().entrySet()) {
            if (!entry.getValue().contains(host)) continue;
            entry.getKey().notifyFeatureChanged(host, feature, notification);
        }
    }

    private void initReversedFeatureMap() {
        for (Table.Cell valueToFeatureHolderMap : this.valueToFeatureToHolderMap.cellSet()) {
            Object feature = valueToFeatureHolderMap.getColumnKey();
            for (EObject holder : (Set)valueToFeatureHolderMap.getValue()) {
                this.addToReversedFeatureMap(feature, holder);
            }
        }
    }

    private void initDirectFeatureMap() {
        for (Table.Cell valueToFeatureHolderMap : this.valueToFeatureToHolderMap.cellSet()) {
            Object value = valueToFeatureHolderMap.getRowKey();
            Object feature = valueToFeatureHolderMap.getColumnKey();
            for (EObject holder : (Set)valueToFeatureHolderMap.getValue()) {
                this.addToDirectFeatureMap(holder, feature, value);
            }
        }
    }

    protected void setTarget(ResourceSet target) {
        this.basicSetTarget((Notifier)target);
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            if (!notifier.eAdapters().contains((Object)this)) {
                this.addAdapter(notifier);
            }
            ++i;
        }
    }

    protected void setTarget(EObject target) {
        this.basicSetTarget((Notifier)target);
        this.spreadToChildren(target, true);
    }

    protected void unsetTarget(EObject target) {
        this.basicUnsetTarget((Notifier)target);
        this.spreadToChildren(target, false);
    }

    protected void spreadToChildren(EObject target, boolean add) {
        EList features = target.eClass().getEAllReferences();
        for (EReference feature : features) {
            if (!feature.isContainment() || !this.comprehension.representable((EStructuralFeature)feature)) continue;
            if (feature.isMany()) {
                Collection values = (Collection)target.eGet((EStructuralFeature)feature);
                for (Object value : values) {
                    Notifier notifier = (Notifier)value;
                    if (add) {
                        this.addAdapter(notifier);
                        continue;
                    }
                    this.removeAdapter(notifier);
                }
                continue;
            }
            Object value = target.eGet((EStructuralFeature)feature);
            if (value == null) continue;
            Notifier notifier = (Notifier)value;
            if (add) {
                this.addAdapter(notifier);
                continue;
            }
            this.removeAdapter(notifier);
        }
    }

    protected Table<Object, Object, Set<EObject>> getValueToFeatureToHolderMap() {
        return this.valueToFeatureToHolderMap;
    }

    protected Map<Object, Multiset<EObject>> getFeatureToHolderMap() {
        if (this.featureToHolderMap == null) {
            this.featureToHolderMap = new HashMap<Object, Multiset<EObject>>();
            this.initReversedFeatureMap();
        }
        return this.featureToHolderMap;
    }

    protected Map<Object, Multiset<EObject>> peekFeatureToHolderMap() {
        return this.featureToHolderMap;
    }

    protected Table<EObject, Object, Set<Object>> getHolderToFeatureToValueMap() {
        if (this.holderToFeatureToValueMap == null) {
            this.holderToFeatureToValueMap = HashBasedTable.create();
            this.initDirectFeatureMap();
        }
        return this.holderToFeatureToValueMap;
    }

    protected Table<EObject, Object, Set<Object>> peekHolderToFeatureToValueMap() {
        return this.holderToFeatureToValueMap;
    }

    protected Map<Object, Set<Object>> getSubTypeMap() {
        return this.subTypeMap;
    }

    protected Map<Object, Set<Object>> getSuperTypeMap() {
        return this.superTypeMap;
    }

    public EStructuralFeature getKnownFeature(String featureId) {
        ETypedElement next;
        Collection features = this.uniqueIDToTypedElement.get((Object)featureId);
        if (features != null && !features.isEmpty() && (next = (ETypedElement)features.iterator().next()) instanceof EStructuralFeature) {
            return (EStructuralFeature)next;
        }
        return null;
    }

    public EStructuralFeature getKnownFeatureForKey(Object featureKey) {
        EStructuralFeature feature = this.isDynamicModel() ? this.getKnownFeature((String)featureKey) : (EStructuralFeature)featureKey;
        return feature;
    }

    public EClassifier getKnownClassifier(String key) {
        Collection classifiersOfThisID = this.uniqueIDToClassifier.get((Object)key);
        if (classifiersOfThisID != null && !classifiersOfThisID.isEmpty()) {
            return (EClassifier)classifiersOfThisID.iterator().next();
        }
        return null;
    }

    public EClassifier getKnownClassifierForKey(Object classifierKey) {
        EClassifier cls = this.isDynamicModel() ? this.getKnownClassifier((String)classifierKey) : (EClassifier)classifierKey;
        return cls;
    }

    public Set<EClass> getAllCurrentClasses() {
        HashSet result = Sets.newHashSet();
        Set<Object> classifierKeys = this.instanceMap.keySet();
        for (Object classifierKey : classifierKeys) {
            if (this.isDynamicModel) {
                EClassifier knownClassifier = this.getKnownClassifier((String)classifierKey);
                if (!(knownClassifier instanceof EClass)) continue;
                result.add((EClass)knownClassifier);
                continue;
            }
            result.add((EClass)classifierKey);
        }
        return result;
    }

    public boolean isDynamicModel() {
        return this.isDynamicModel;
    }

    protected void resampleFeatureValueForHolder(EObject source, EStructuralFeature feature, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        Object newValue = source.eGet(feature);
        Set<Object> oldValues = this.getOldValuesForHolderAndFeature(source, feature);
        if (feature.isMany()) {
            this.resampleManyFeatureValueForHolder(source, feature, newValue, oldValues, insertionVisitor, removalVisitor);
        } else {
            this.resampleSingleFeatureValueForHolder(source, feature, newValue, oldValues, insertionVisitor, removalVisitor);
        }
    }

    private Set<Object> getOldValuesForHolderAndFeature(EObject source, EStructuralFeature feature) {
        Map oldValuesToHolders = this.valueToFeatureToHolderMap.column((Object)feature);
        HashSet<Object> oldValues = new HashSet<Object>();
        for (Map.Entry entry : oldValuesToHolders.entrySet()) {
            if (!((Set)entry.getValue()).contains(source)) continue;
            oldValues.add(entry.getKey());
        }
        return oldValues;
    }

    private void resampleManyFeatureValueForHolder(EObject source, EStructuralFeature feature, Object newValue, Set<Object> oldValues, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        InternalEObject internalEObject = (InternalEObject)source;
        Collection newValues = (Collection)newValue;
        HashSet newValueSet = new HashSet(newValues);
        newValueSet.removeAll(oldValues);
        oldValues.removeAll(newValues);
        if (!oldValues.isEmpty()) {
            for (Object ov : oldValues) {
                this.comprehension.traverseFeature(removalVisitor, source, feature, ov, null);
            }
            ENotificationImpl removeNotification = new ENotificationImpl(internalEObject, 6, feature, oldValues, null);
            this.notifyLightweightObservers(source, feature, (Notification)removeNotification);
        }
        if (!newValueSet.isEmpty()) {
            for (Object nv : newValueSet) {
                this.comprehension.traverseFeature(insertionVisitor, source, feature, nv, null);
            }
            ENotificationImpl addNotification = new ENotificationImpl(internalEObject, 5, feature, null, newValueSet);
            this.notifyLightweightObservers(source, feature, (Notification)addNotification);
        }
    }

    private void resampleSingleFeatureValueForHolder(EObject source, EStructuralFeature feature, Object newValue, Set<Object> oldValues, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        InternalEObject internalEObject = (InternalEObject)source;
        Object oldValue = Iterables.getFirst(oldValues, null);
        if (!Objects.equal((Object)oldValue, (Object)newValue)) {
            this.comprehension.traverseFeature(removalVisitor, source, feature, oldValue, null);
            this.comprehension.traverseFeature(insertionVisitor, source, feature, newValue, null);
            ENotificationImpl notification = new ENotificationImpl(internalEObject, 1, feature, oldValue, newValue);
            this.notifyLightweightObservers(source, feature, (Notification)notification);
        }
    }

    public void setTarget(Notifier target) {
        if (this.objectFilterConfiguration != null && this.objectFilterConfiguration.isFiltered(target)) {
            return;
        }
        super.setTarget(target);
    }

    public void unsetTarget(Notifier target) {
        if (this.objectFilterConfiguration != null && this.objectFilterConfiguration.isFiltered(target)) {
            return;
        }
        super.unsetTarget(target);
    }

    public void setTarget(Resource target) {
        if (this.resourceFilterConfiguration != null && this.resourceFilterConfiguration.isResourceFiltered(target)) {
            return;
        }
        super.setTarget(target);
    }

    public void unsetTarget(Resource target) {
        if (this.resourceFilterConfiguration != null && this.resourceFilterConfiguration.isResourceFiltered(target)) {
            return;
        }
        super.unsetTarget(target);
    }
}

