/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.base.api.QueryResultAssociativeStore;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.Direction;

public abstract class QueryResultMultimap<KeyType, ValueType>
extends QueryResultAssociativeStore<KeyType, ValueType>
implements Multimap<KeyType, ValueType> {
    private Multimap<KeyType, ValueType> cache = HashMultimap.create();

    protected QueryResultMultimap(Logger logger) {
        this.setLogger(logger);
    }

    @Override
    protected Collection<Map.Entry<KeyType, ValueType>> getCacheEntries() {
        return this.cache.entries();
    }

    @Override
    protected boolean internalCachePut(KeyType key, ValueType value) {
        return this.cache.put(key, value);
    }

    @Override
    protected boolean internalCacheRemove(KeyType key, ValueType value) {
        return this.cache.remove(key, value);
    }

    @Override
    protected boolean internalCacheContainsEntry(KeyType key, ValueType value) {
        return this.cache.containsEntry(key, value);
    }

    @Override
    protected int internalCacheSize() {
        return this.cache.size();
    }

    protected Multimap<KeyType, ValueType> getCache() {
        return this.cache;
    }

    protected void setCache(Multimap<KeyType, ValueType> cache) {
        this.cache = cache;
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public boolean containsEntry(Object key, Object value) {
        return this.cache.containsEntry(key, value);
    }

    public Collection<ValueType> get(KeyType key) {
        return Collections.unmodifiableCollection(this.cache.get(key));
    }

    public Set<KeyType> keySet() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    public Multiset<KeyType> keys() {
        return Multisets.unmodifiableMultiset((Multiset)this.cache.keys());
    }

    public Collection<ValueType> values() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    public Collection<Map.Entry<KeyType, ValueType>> entries() {
        return Collections.unmodifiableCollection(this.getCacheEntries());
    }

    public Map<KeyType, Collection<ValueType>> asMap() {
        return Collections.unmodifiableMap(this.cache.asMap());
    }

    public boolean put(KeyType key, ValueType value) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        return this.modifyThroughQueryResultSetter(key, value, Direction.INSERT);
    }

    public boolean remove(Object key, Object value) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        if (this.cache.containsEntry(key, value)) {
            return this.modifyThroughQueryResultSetter(key, value, Direction.DELETE);
        }
        return false;
    }

    public boolean putAll(KeyType key, Iterable<? extends ValueType> values) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        boolean changed = false;
        for (ValueType value : values) {
            changed |= this.modifyThroughQueryResultSetter(key, value, Direction.INSERT);
        }
        return changed;
    }

    public boolean putAll(Multimap<? extends KeyType, ? extends ValueType> multimap) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= this.modifyThroughQueryResultSetter(entry.getKey(), entry.getValue(), Direction.INSERT);
        }
        return changed;
    }

    public Collection<ValueType> replaceValues(KeyType key, Iterable<? extends ValueType> values) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        Collection<ValueType> oldValues = this.removeAll(key);
        Iterator<ValueType> iterator = values.iterator();
        ArrayList notInserted = Lists.newArrayList();
        while (iterator.hasNext()) {
            ValueType value = iterator.next();
            if (this.modifyThroughQueryResultSetter(key, value, Direction.INSERT)) continue;
            notInserted.add(value);
        }
        if (!notInserted.isEmpty()) {
            this.getLogger().warn((Object)String.format("The query result multimap replaceValues on key %s did not insert values %s. (Developer note: %s called from QueryResultMultimap)", key, ((Object)notInserted).toString(), this.getSetter()));
        }
        return oldValues;
    }

    public Collection<ValueType> removeAll(Object key) {
        if (this.getSetter() == null) {
            throw new UnsupportedOperationException("Query result associative store does not allow modifications");
        }
        if (this.cache.containsKey(key)) {
            Collection collection = this.cache.get(key);
            ImmutableSet output = ImmutableSet.copyOf((Collection)collection);
            for (Object valueType : output) {
                this.modifyThroughQueryResultSetter(key, valueType, Direction.DELETE);
            }
            if (this.cache.containsKey(key)) {
                Collection newValues = this.cache.get(key);
                this.getLogger().warn((Object)String.format("The query result multimap removeAll on key %s did not remove all values (the following remained: %s). (Developer note: %s called from QueryResultMultimap)", key, newValues, this.getSetter()));
            }
            return output;
        }
        return Collections.EMPTY_SET;
    }

    public void clear() {
        this.internalClear();
    }
}

