/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.job.EnableJob;
import org.eclipse.incquery.runtime.evm.specific.job.ErrorLoggingJob;
import org.eclipse.incquery.runtime.evm.specific.job.EventAtomDomainObjectProvider;
import org.eclipse.incquery.runtime.evm.specific.job.RecordingJob;
import org.eclipse.incquery.runtime.evm.specific.job.StatelessJob;

public final class Jobs {
    private Jobs() {
    }

    public static <Match extends IPatternMatch> Job<Match> newStatelessJob(IncQueryActivationStateEnum incQueryActivationStateEnum, IMatchProcessor<Match> processor) {
        return new StatelessJob<Match>(incQueryActivationStateEnum, processor);
    }

    @Deprecated
    public static <Match extends IPatternMatch> Job<Match> newRecordingJob(IncQueryActivationStateEnum incQueryActivationStateEnum, IMatchProcessor<Match> processor) {
        return new RecordingJob<Match>(new StatelessJob<Match>(incQueryActivationStateEnum, processor), new EventAtomDomainObjectProvider<Match>(){

            @Override
            public Object findDomainObject(Activation<? extends Match> activation, Context context) {
                IPatternMatch match = (IPatternMatch)activation.getAtom();
                int arity = match.parameterNames().size();
                if (arity > 0) {
                    int i = 0;
                    while (i < arity) {
                        if (match.get(i) instanceof EObject) {
                            return match.get(i);
                        }
                        ++i;
                    }
                }
                return null;
            }
        });
    }

    public static <EventAtom> Job<EventAtom> newRecordingJob(Job<EventAtom> job) {
        return new RecordingJob<EventAtom>(job);
    }

    public static final <EventAtom> Job<EventAtom> newNopJob(ActivationState activationState) {
        return new Job<EventAtom>(activationState){

            @Override
            protected void execute(Activation<? extends EventAtom> activation, Context context) {
            }

            @Override
            protected void handleError(Activation<? extends EventAtom> activation, Exception exception, Context context) {
                Preconditions.checkState((boolean)false, (Object)"NopJob should never cause errors!");
            }
        };
    }

    @Deprecated
    public static <Match extends IPatternMatch> Job<Match> newEnableJob(IncQueryActivationStateEnum incQueryActivationStateEnum, IMatchProcessor<Match> processor) {
        return new EnableJob<Match>(new StatelessJob<Match>(incQueryActivationStateEnum, processor));
    }

    public static <EventAtom> Job<EventAtom> newEnableJob(Job<EventAtom> job) {
        return new EnableJob<EventAtom>(job);
    }

    public static <EventAtom> Job<EventAtom> newErrorLoggingJob(Job<EventAtom> job) {
        return new ErrorLoggingJob<EventAtom>(job);
    }
}

