/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.EventType;
import org.eclipse.incquery.runtime.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictResolver;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictSetUpdater;
import org.eclipse.incquery.runtime.evm.notification.IActivationNotificationListener;

public class Agenda {
    private final Multimap<ActivationState, Activation<?>> activations;
    private ChangeableConflictSet conflictSet;
    private final IActivationNotificationListener activationListener;
    private final RuleBase ruleBase;
    private ConflictSetUpdater updatingListener;
    private final Logger logger;

    public Agenda(RuleBase ruleBase, ConflictResolver conflictResolver) {
        this.ruleBase = ruleBase;
        this.logger = ruleBase.getLogger();
        Preconditions.checkState((this.logger != null ? 1 : 0) != 0, (Object)"Rulebase logger is null!");
        this.activations = HashMultimap.create();
        this.conflictSet = conflictResolver.createConflictSet();
        this.updatingListener = new ConflictSetUpdater(this.conflictSet);
        this.activationListener = new DefaultActivationNotificationListener();
    }

    public Multimap<ActivationState, Activation<?>> getActivations() {
        return this.activations;
    }

    public Collection<Activation<?>> getActivations(ActivationState state) {
        return this.getActivations().get((Object)state);
    }

    public Collection<Activation<?>> getAllActivations() {
        return this.getActivations().values();
    }

    public IActivationNotificationListener getActivationListener() {
        return this.activationListener;
    }

    public void setConflictResolver(ConflictResolver resolver) {
        ChangeableConflictSet set = resolver.createConflictSet();
        for (Activation<?> act : this.conflictSet.getConflictingActivations()) {
            set.addActivation(act);
        }
        this.updatingListener = new ConflictSetUpdater(set);
        this.conflictSet = set;
    }

    public ChangeableConflictSet getConflictSet() {
        return this.conflictSet;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    private final class DefaultActivationNotificationListener
    implements IActivationNotificationListener {
        private DefaultActivationNotificationListener() {
        }

        @Override
        public void activationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
            if (Agenda.this.logger.isDebugEnabled()) {
                Agenda.this.logger.debug((Object)String.format("%s -- %s --> %s on %s", oldState, event, activation.getState(), activation));
            }
            Agenda.this.getActivations().remove((Object)oldState, activation);
            ActivationState state = activation.getState();
            if (!state.isInactive()) {
                Agenda.this.getActivations().put((Object)state, activation);
            }
            Agenda.this.updatingListener.activationChanged(activation, oldState, event);
        }

        @Override
        public void activationCreated(Activation<?> activation, ActivationState inactiveState) {
            if (Agenda.this.logger.isDebugEnabled()) {
                Agenda.this.logger.debug((Object)String.format("%s -- CREATE --> %s on %s", inactiveState, activation.getState(), activation));
            }
            Agenda.this.updatingListener.activationCreated(activation, inactiveState);
            ActivationState state = activation.getState();
            Agenda.this.getActivations().put((Object)state, activation);
        }

        @Override
        public void activationRemoved(Activation<?> activation, ActivationState oldState) {
            if (Agenda.this.logger.isDebugEnabled()) {
                Agenda.this.logger.debug((Object)String.format("%s -- REMOVE --> %s on %s", oldState, activation.getState(), activation));
            }
            Agenda.this.getActivations().remove((Object)oldState, activation);
            Agenda.this.updatingListener.activationRemoved(activation, oldState);
        }
    }
}

