/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.planner.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.operations.PApply;
import org.eclipse.incquery.runtime.matchers.planning.operations.POperation;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;

public class CompilerHelper {
    public static Map<PVariable, Integer> createVariableMapping(SubPlan plan) {
        HashMap variableMapping = Maps.newHashMap();
        int variableNumber = 0;
        List symbolicParameterVariables = plan.getBody().getSymbolicParameterVariables();
        for (PVariable pVariable : symbolicParameterVariables) {
            variableMapping.put(pVariable, variableNumber++);
        }
        HashSet allVariables = Sets.newHashSet();
        Set allEnforcedConstraints = plan.getAllEnforcedConstraints();
        for (PConstraint pConstraint : allEnforcedConstraints) {
            allVariables.addAll(pConstraint.getAffectedVariables());
        }
        for (PVariable pVariable : allVariables) {
            if (variableMapping.containsKey(pVariable)) continue;
            variableMapping.put(pVariable, variableNumber++);
        }
        return variableMapping;
    }

    public static Map<PConstraint, Set<Integer>> cacheVariableBindings(SubPlan plan, Map<PVariable, Integer> variableMappings, Set<Integer> adornment) {
        POperation operation;
        HashMap variableBindings = Maps.newHashMap();
        HashMap variableBindingsDebug = Maps.newHashMap();
        while (plan.getParentPlans().size() > 0) {
            operation = plan.getOperation();
            plan = (SubPlan)plan.getParentPlans().get(0);
            if (!(operation instanceof PApply)) continue;
            Set enforcedConstraint = plan.getAllEnforcedConstraints();
            HashSet allDeducedVariables = Sets.newHashSet();
            for (PConstraint pConstraint : enforcedConstraint) {
                allDeducedVariables.addAll(pConstraint.getAffectedVariables());
            }
            variableBindingsDebug.put(((PApply)operation).getPConstraint(), allDeducedVariables);
            HashSet boundVariables = Sets.newHashSet();
            boundVariables.addAll(adornment);
            for (PVariable pVariable : allDeducedVariables) {
                boundVariables.add(variableMappings.get(pVariable));
            }
            variableBindings.put(((PApply)operation).getPConstraint(), boundVariables);
        }
        operation = plan.getOperation();
        if (operation instanceof PApply) {
            HashSet allDeducedVariables = Sets.newHashSet();
            allDeducedVariables.addAll(((PApply)operation).getPConstraint().getAffectedVariables());
            variableBindingsDebug.put(((PApply)operation).getPConstraint(), allDeducedVariables);
            HashSet boundVariables = Sets.newHashSet();
            boundVariables.addAll(adornment);
            for (PVariable pVariable : allDeducedVariables) {
                boundVariables.add(variableMappings.get(pVariable));
            }
            variableBindings.put(((PApply)operation).getPConstraint(), boundVariables);
        }
        return variableBindings;
    }

    public static List<POperation> createOperationsList(SubPlan plan) {
        ArrayList operationsList = Lists.newArrayList();
        while (plan.getParentPlans().size() > 0) {
            SubPlan parentPlan;
            operationsList.add(plan.getOperation());
            plan = parentPlan = (SubPlan)plan.getParentPlans().get(0);
        }
        operationsList.add(plan.getOperation());
        return Lists.reverse((List)operationsList);
    }
}

