/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.context.common;

import org.eclipse.incquery.runtime.matchers.context.common.BaseInputKeyWrapper;

public class JavaTransitiveInstancesKey
extends BaseInputKeyWrapper<String> {
    private Class<?> cachedOriginalInstanceClass;
    private Class<?> cachedWrapperInstanceClass;

    public JavaTransitiveInstancesKey(Class<?> instanceClass) {
        this(JavaTransitiveInstancesKey.primitiveTypeToWrapperClass(instanceClass).getName());
        this.cachedOriginalInstanceClass = instanceClass;
    }

    public JavaTransitiveInstancesKey(String className) {
        super(className);
    }

    private Class<?> getOriginalInstanceClass() {
        if (this.cachedOriginalInstanceClass == null) {
            try {
                this.resolveClassInternal();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this.cachedOriginalInstanceClass;
    }

    private Class<?> forceGetOriginalInstanceClass() throws ClassNotFoundException {
        if (this.cachedOriginalInstanceClass == null) {
            this.resolveClassInternal();
        }
        return this.cachedOriginalInstanceClass;
    }

    public Class<?> forceGetWrapperInstanceClass() throws ClassNotFoundException {
        this.forceGetOriginalInstanceClass();
        return this.getWrapperInstanceClass();
    }

    public Class<?> forceGetInstanceClass() throws ClassNotFoundException {
        return this.forceGetWrapperInstanceClass();
    }

    public Class<?> getWrapperInstanceClass() {
        if (this.cachedWrapperInstanceClass == null) {
            this.cachedWrapperInstanceClass = JavaTransitiveInstancesKey.primitiveTypeToWrapperClass(this.getOriginalInstanceClass());
        }
        return this.cachedWrapperInstanceClass;
    }

    public Class<?> getInstanceClass() {
        return this.getWrapperInstanceClass();
    }

    private void resolveClassInternal() throws ClassNotFoundException {
        this.cachedOriginalInstanceClass = Class.forName((String)this.wrappedKey);
    }

    @Override
    public String getPrettyPrintableName() {
        this.getWrapperInstanceClass();
        return this.cachedWrapperInstanceClass == null ? (this.wrappedKey == null ? "<null>" : (String)this.wrappedKey) : this.cachedWrapperInstanceClass.getName();
    }

    @Override
    public String getStringID() {
        return "javaClass#" + this.getPrettyPrintableName();
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    public String toString() {
        return this.getPrettyPrintableName();
    }

    private static Class<?> primitiveTypeToWrapperClass(Class<?> instanceClass) {
        if (instanceClass.isPrimitive()) {
            if (Void.TYPE.equals(instanceClass)) {
                return Void.class;
            }
            if (Boolean.TYPE.equals(instanceClass)) {
                return Boolean.class;
            }
            if (Character.TYPE.equals(instanceClass)) {
                return Character.class;
            }
            if (Byte.TYPE.equals(instanceClass)) {
                return Byte.class;
            }
            if (Short.TYPE.equals(instanceClass)) {
                return Short.class;
            }
            if (Integer.TYPE.equals(instanceClass)) {
                return Integer.class;
            }
            if (Long.TYPE.equals(instanceClass)) {
                return Long.class;
            }
            if (Float.TYPE.equals(instanceClass)) {
                return Float.class;
            }
            if (Double.TYPE.equals(instanceClass)) {
                return Double.class;
            }
        }
        return instanceClass;
    }
}

