/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PBodyNormalizer
extends PDisjunctionRewriter {
    public boolean calcImpliedTypes;
    private IQueryMetaContext context;

    public PBodyNormalizer(IQueryMetaContext context) {
        this(context, true);
    }

    public PBodyNormalizer(IQueryMetaContext context, boolean calculateImpliedTypes) {
        this.context = context;
        this.calcImpliedTypes = calculateImpliedTypes;
    }

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        HashSet normalizedBodies = Sets.newHashSet();
        for (PBody body : disjunction.getBodies()) {
            PBodyCopier copier = new PBodyCopier(body);
            PBody modifiedBody = copier.getCopiedBody();
            this.normalizeBody(modifiedBody);
            normalizedBodies.add(modifiedBody);
            modifiedBody.setStatus(PQuery.PQueryStatus.OK);
        }
        return new PDisjunction(normalizedBodies);
    }

    public void setContext(IQueryMetaContext context) {
        this.context = context;
    }

    public PBody normalizeBody(PBody body) throws RewriterException {
        try {
            return this.normalizeBodyInternal(body);
        }
        catch (QueryProcessingException e) {
            throw new RewriterException("Error during rewriting: {1}", new String[]{e.getMessage()}, e.getShortMessage(), body.getPattern(), e);
        }
    }

    PBody normalizeBodyInternal(PBody body) throws QueryProcessingException {
        this.unifyVariablesAlongEqualities(body);
        this.eliminateWeakInequalities(body);
        this.removeMootEqualities(body);
        if (this.calcImpliedTypes) {
            this.eliminateInferrableTypes(body, this.context);
        }
        this.checkSanity(body);
        return body;
    }

    private void removeMootEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (!equality.isMoot()) continue;
            equality.delete();
        }
    }

    void unifyVariablesAlongEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (equality.isMoot()) continue;
            equality.getWho().unifyInto(equality.getWithWhom());
        }
    }

    void eliminateWeakInequalities(PBody body) {
        for (Inequality inequality : body.getConstraintsOfType(Inequality.class)) {
            inequality.eliminateWeak();
        }
    }

    void eliminateInferrableTypes(PBody body, IQueryMetaContext context) {
        HashSet<TypeJudgement> subsumedByRetainedConstraints = new HashSet<TypeJudgement>();
        LinkedList<ITypeConstraint> allTypeConstraints = new LinkedList<ITypeConstraint>();
        for (PConstraint pConstraint : body.getConstraints()) {
            if (pConstraint instanceof ITypeConstraint) {
                allTypeConstraints.add((ITypeConstraint)pConstraint);
                continue;
            }
            if (!(pConstraint instanceof ITypeInfoProviderConstraint)) continue;
            Set<TypeJudgement> directJudgements = ((ITypeInfoProviderConstraint)pConstraint).getImpliedJudgements(context);
            subsumedByRetainedConstraints.addAll(TypeHelper.typeClosure(directJudgements, context));
        }
        Collections.sort(allTypeConstraints, PConstraint.CompareByMonotonousID.INSTANCE);
        LinkedList<ITypeConstraint> potentialConstraints = allTypeConstraints;
        while (!potentialConstraints.isEmpty()) {
            ITypeConstraint candidate = (ITypeConstraint)potentialConstraints.poll();
            boolean isSubsumed = subsumedByRetainedConstraints.contains(candidate.getEquivalentJudgement());
            if (!isSubsumed) {
                for (ITypeConstraint subsuming : potentialConstraints) {
                    Set<TypeJudgement> directJudgements = subsuming.getImpliedJudgements(context);
                    Set<TypeJudgement> typeClosure = TypeHelper.typeClosure(directJudgements, context);
                    if (!typeClosure.contains(candidate.getEquivalentJudgement())) continue;
                    isSubsumed = true;
                    break;
                }
            }
            if (isSubsumed) {
                candidate.delete();
                continue;
            }
            subsumedByRetainedConstraints.addAll(TypeHelper.typeClosure(candidate.getImpliedJudgements(context), context));
        }
    }

    void checkSanity(PBody body) throws QueryProcessingException {
        for (PConstraint pConstraint : body.getConstraints()) {
            pConstraint.checkSanity();
        }
    }
}

