/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.util;

import com.google.inject.Injector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.incquery.tooling.ui.queryexplorer.handlers.RuntimeMatcherRegistrator;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.swt.widgets.Display;

class DeltaVisitor
implements IResourceDeltaVisitor {
    private final Injector injector;

    public DeltaVisitor(Injector injector) {
        this.injector = injector;
    }

    public boolean visit(IResourceDelta delta) {
        IResource res = delta.getResource();
        if (res instanceof IFile && delta.getKind() == 4) {
            IFile file = (IFile)res;
            if (QueryExplorerPatternRegistry.getInstance().getFiles().contains(file)) {
                RuntimeMatcherRegistrator registrator = new RuntimeMatcherRegistrator(file);
                this.injector.injectMembers((Object)registrator);
                Display.getDefault().asyncExec((Runnable)registrator);
            }
            return false;
        }
        return true;
    }
}

