/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.ui.wizards.NewEiqGenmodelPage;
import org.eclipse.incquery.tooling.ui.wizards.SelectIncQueryProjectPage;
import org.eclipse.incquery.tooling.ui.wizards.internal.operations.CompositeWorkspaceModifyOperation;
import org.eclipse.incquery.tooling.ui.wizards.internal.operations.CreateGenmodelOperation;
import org.eclipse.incquery.tooling.ui.wizards.internal.operations.EnsureProjectDependencies;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class NewGenmodelWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private SelectIncQueryProjectPage projectPage;
    private NewEiqGenmodelPage genmodelPage;
    @Inject
    private IEiqGenmodelProvider genmodelProvider;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private Logger logger;

    public void addPages() {
        this.projectPage = new SelectIncQueryProjectPage("Select EMF-IncQuery project", this.selection, this.logger);
        this.addPage((IWizardPage)this.projectPage);
        this.genmodelPage = new NewEiqGenmodelPage(false);
        this.addPage((IWizardPage)this.genmodelPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public boolean performFinish() {
        IProject project = this.projectPage.getSelectedProject();
        CompositeWorkspaceModifyOperation op = null;
        ArrayList<String> genmodelDependencies = new ArrayList<String>();
        for (GenModel model : this.genmodelPage.getSelectedGenmodels()) {
            String modelPluginID = model.getModelPluginID();
            if (genmodelDependencies.contains(modelPluginID)) continue;
            genmodelDependencies.add(modelPluginID);
        }
        EnsureProjectDependencies projectOp = new EnsureProjectDependencies(project, genmodelDependencies);
        CreateGenmodelOperation genmodelOp = new CreateGenmodelOperation(project, this.genmodelPage.getSelectedGenmodels(), this.genmodelProvider, this.resourceSetProvider);
        op = new CompositeWorkspaceModifyOperation(new WorkspaceModifyOperation[]{projectOp, genmodelOp}, "Creating generator model");
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            this.logger.error((Object)("Cannot initialize EMF-IncQuery generator model " + realException.getMessage()), realException);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        IFile genmodelFile = (IFile)project.findMember("generator.eiqgen");
        BasicNewProjectResourceWizard.selectAndReveal((IResource)genmodelFile, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)new FileEditorInput(genmodelFile), this.workbench.getEditorRegistry().getDefaultEditor(genmodelFile.getName()).getId());
        }
        catch (PartInitException e) {
            this.logger.error((Object)"Cannot open EMF-IncQuery generator model", (Throwable)e);
        }
        return true;
    }
}

