/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternComponent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternLeaf;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;

public class CheckStateListener
implements ICheckStateListener {
    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        Collection<PatternComponent> changedComponents = ((PatternComponent)element).setCheckedState(event.getChecked());
        for (PatternComponent component : changedComponents) {
            PatternMatcherRootContent root;
            Iterator<PatternMatcherRootContent> iterator;
            if (!(component instanceof PatternLeaf)) continue;
            String patternFqn = ((PatternLeaf)component).getFullPatternNamePrefix();
            IQuerySpecification<?> specification = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(patternFqn);
            if (event.getChecked() && !QueryExplorerPatternRegistry.getInstance().isActive(patternFqn)) {
                iterator = QueryExplorer.getInstance().getRootContent().getChildrenIterator();
                while (iterator.hasNext()) {
                    root = iterator.next();
                    root.registerPattern(specification);
                    root.updateHasChildren();
                }
                QueryExplorerPatternRegistry.getInstance().addActivePattern(specification);
                continue;
            }
            if (event.getChecked()) continue;
            iterator = QueryExplorer.getInstance().getRootContent().getChildrenIterator();
            while (iterator.hasNext()) {
                root = iterator.next();
                root.unregisterPattern(specification);
                root.updateHasChildren();
            }
            QueryExplorerPatternRegistry.getInstance().removeActivePattern(specification);
        }
    }
}

