package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ProtocolTransitionReferredMatch;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.ProtocolTransition;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.protocolTransitionReferred pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ProtocolTransitionReferredProcessor implements IMatchProcessor<ProtocolTransitionReferredMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pOperation the value of pattern parameter operation in the currently processed match
   * 
   */
  public abstract void process(final ProtocolTransition pSelf, final Operation pOperation);
  
  @Override
  public void process(final ProtocolTransitionReferredMatch match) {
    process(match.getSelf(), match.getOperation());
  }
}
