/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.contentassist;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguageFactory;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.XImportSection;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

final class PatternImporter
extends ReplacementTextApplier {
    private final Pattern targetPattern;
    private final String targetPackage;
    private ImportState importStatus;

    public PatternImporter(Pattern targetPattern) {
        this.targetPattern = targetPattern;
        this.targetPackage = CorePatternLanguageHelper.getPackageName((Pattern)targetPattern);
    }

    public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        if (document instanceof IXtextDocument) {
            IXtextDocument xtextDocument = (IXtextDocument)document;
            if (this.targetPattern == null || Strings.isNullOrEmpty((String)this.targetPattern.getName())) {
                return;
            }
            this.importStatus = (ImportState)((Object)((IXtextDocument)document).readOnly((IUnitOfWork)new IUnitOfWork<ImportState, XtextResource>(){

                public ImportState exec(XtextResource state) throws Exception {
                    PatternModel model = (PatternModel)Iterators.find((Iterator)state.getAllContents(), (Predicate)Predicates.instanceOf(PatternModel.class));
                    if (PatternImporter.this.targetPackage.equals(model.getPackageName())) {
                        return ImportState.SAMEPACKAGE;
                    }
                    XImportSection importSection = model.getImportPackages();
                    PatternImport relatedImport = (PatternImport)Iterables.find((Iterable)importSection.getPatternImport(), (Predicate)new Predicate<PatternImport>(){

                        public boolean apply(PatternImport decl) {
                            return PatternImporter.this.targetPattern.equals(decl.getPattern()) || PatternImporter.this.targetPattern.getName().equals(decl.getPattern().getName());
                        }
                    }, null);
                    if (relatedImport == null) {
                        return ImportState.NONE;
                    }
                    if (PatternImporter.this.targetPattern.equals(relatedImport.getPattern())) {
                        return ImportState.FOUND;
                    }
                    return ImportState.CONFLICTING;
                }
            }));
            String replacementString = String.valueOf(this.getActualReplacementString(proposal)) + "();";
            ReplaceEdit edit = new ReplaceEdit(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
            edit.apply(document);
            int cursorOffset = this.getActualReplacementString(proposal).length() + 2;
            if (this.importStatus == ImportState.NONE) {
                xtextDocument.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        XImportSection importSection = (XImportSection)Iterators.find((Iterator)state.getAllContents(), (Predicate)Predicates.instanceOf(XImportSection.class), null);
                        if (importSection.getImportDeclarations().size() + importSection.getPackageImport().size() + importSection.getPatternImport().size() == 0) {
                            XImportSection newSection = EMFPatternLanguageFactory.eINSTANCE.createXImportSection();
                            ((PatternModel)importSection.eContainer()).setImportPackages(newSection);
                            importSection = newSection;
                        }
                        PatternImport newImport = EMFPatternLanguageFactory.eINSTANCE.createPatternImport();
                        newImport.setPattern(PatternImporter.this.targetPattern);
                        importSection.getPatternImport().add((Object)newImport);
                    }
                });
                cursorOffset += 9 + CorePatternLanguageHelper.getFullyQualifiedName((Pattern)this.targetPattern).length();
            }
            proposal.setCursorPosition(cursorOffset);
        }
    }

    public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
        if (this.importStatus != ImportState.CONFLICTING) {
            return this.targetPattern.getName();
        }
        return CorePatternLanguageHelper.getFullyQualifiedName((Pattern)this.targetPattern);
    }

    private static enum ImportState {
        NONE,
        SAMEPACKAGE,
        FOUND,
        CONFLICTING;

    }
}

