/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gef4.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.IndexerWithMemory;
import org.eclipse.incquery.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.incquery.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.incquery.runtime.rete.matcher.RetePatternMatcher;
import org.eclipse.incquery.runtime.rete.misc.ConstantNode;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.single.UniquenessEnforcerNode;
import org.eclipse.incquery.runtime.rete.traceability.CompiledSubPlan;
import org.eclipse.incquery.runtime.rete.traceability.PlanningTrace;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;
import org.eclipse.incquery.runtime.rete.tuple.MaskedTupleMemory;
import org.eclipse.incquery.tooling.ui.retevis.theme.ColorTheme;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;

public class ZestReteLabelProvider
extends LabelProvider
implements IEntityStyleProvider {
    private static final int INDEXER_ID = 0;
    private static final int RETEMATCHER_ID = 1;
    private static final int INPUT_ID = 2;
    private ReteBoundary rb;
    private ColorTheme theme;

    public void setColors(ColorTheme theme) {
        this.theme = theme;
    }

    public ReteBoundary getRb() {
        return this.rb;
    }

    public void setRb(ReteBoundary rb) {
        this.rb = rb;
    }

    public String getText(Object element) {
        if (element instanceof Node) {
            String simpleName;
            Node n = (Node)element;
            Class<?> namedClass = n.getClass();
            do {
                simpleName = namedClass.getSimpleName();
                namedClass = namedClass.getSuperclass();
            } while (simpleName == null || simpleName.isEmpty());
            StringBuilder sb = new StringBuilder(simpleName);
            if (n instanceof UniquenessEnforcerNode) {
                UniquenessEnforcerNode un = (UniquenessEnforcerNode)n;
                if (un.getParents().isEmpty() && un.getTag() instanceof ENamedElement) {
                    sb.append(" : " + ((ENamedElement)un.getTag()).getName() + " : ");
                }
                sb.append(" [" + un.getMemory().size() + "]");
            }
            if (n instanceof IndexerWithMemory) {
                MaskedTupleMemory mem = ((IndexerWithMemory)n).getMemory();
                sb.append(" [" + mem.getKeysetSize() + " => " + mem.getTotalSize() + "]");
            }
            if (n instanceof MemoryIdentityIndexer) {
                sb.append(" [" + ((MemoryIdentityIndexer)n).getSignatures().size() + "]");
            }
            if (n instanceof MemoryNullIndexer) {
                sb.append(" [" + ((MemoryNullIndexer)n).getSignatures().size() + "]");
            }
            if (!(n instanceof UniquenessEnforcerNode) && !(n instanceof ConstantNode)) {
                sb.append("\n");
                for (PlanningTrace trace : this.getStubsForNode(n)) {
                    sb.append("<");
                    List variablesTuple = trace.getVariablesTuple();
                    for (PVariable var : variablesTuple) {
                        sb.append(var.getName());
                        sb.append("; ");
                    }
                    sb.append(">  ");
                }
            }
            if (n instanceof RetePatternMatcher) {
                sb.append(" '" + ((PQuery)((RetePatternMatcher)n).getTag()).getFullyQualifiedName() + "'");
            }
            return sb.toString();
        }
        return "!";
    }

    public IFigure getTooltip(Object entity) {
        if (entity instanceof Node) {
            Node n = (Node)entity;
            StringBuilder infoBuilder = new StringBuilder("Stubs:\n");
            for (PlanningTrace trace : this.getStubsForNode(n)) {
                if (!(trace instanceof CompiledSubPlan)) continue;
                infoBuilder.append(ZestReteLabelProvider.getEnforcedConstraints(trace.getSubPlan()));
            }
            FlowPage fp = new FlowPage();
            TextFlow nameTf = new TextFlow();
            TextFlow infoTf = new TextFlow();
            nameTf.setText(n.toString());
            infoTf.setText(infoBuilder.toString());
            if (entity instanceof RetePatternMatcher) {
                if (((Node)entity).getTag() instanceof Pattern) {
                    Pattern pattern = (Pattern)((Node)entity).getTag();
                    nameTf.setText(pattern.getName());
                    fp.add((IFigure)nameTf);
                }
            } else if (entity instanceof ConstantNode) {
                ConstantNode node = (ConstantNode)entity;
                ArrayList arrayList = new ArrayList();
                node.pullInto(arrayList);
                StringBuilder sb = new StringBuilder();
                for (Tuple tuple : arrayList) {
                    sb.append(String.valueOf(tuple.toString()) + "\n");
                }
                nameTf.setText(sb.toString());
                fp.add((IFigure)nameTf);
            }
            fp.add((IFigure)infoTf);
            return fp;
        }
        return null;
    }

    private static String getEnforcedConstraints(SubPlan st) {
        StringBuilder sb = new StringBuilder();
        for (Object _pc : st.getAllEnforcedConstraints()) {
            PConstraint pc = (PConstraint)_pc;
            sb.append("\t[" + pc.getClass().getSimpleName() + "]:");
            for (PVariable v : pc.getAffectedVariables()) {
                sb.append("{" + v.getName() + "}");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private Collection<PlanningTrace> getStubsForNode(Node n) {
        HashSet<PlanningTrace> result = new HashSet<PlanningTrace>();
        if (n != null) {
            Set traceInfos = n.getTraceInfos();
            for (TraceInfo traceInfo : traceInfos) {
                if (!(traceInfo instanceof PlanningTrace)) continue;
                result.add((PlanningTrace)traceInfo);
            }
        }
        return result;
    }

    public Color getNodeHighlightColor(Object entity) {
        return null;
    }

    public Color getBorderColor(Object entity) {
        return null;
    }

    public Color getBorderHighlightColor(Object entity) {
        return null;
    }

    public int getBorderWidth(Object entity) {
        return 0;
    }

    public Color getBackgroundColour(Object entity) {
        UniquenessEnforcerNode inputNode;
        if (entity instanceof Indexer) {
            return this.theme.getNodeColor(0);
        }
        if (entity instanceof RetePatternMatcher) {
            return this.theme.getNodeColor(1);
        }
        if (entity instanceof UniquenessEnforcerNode && (inputNode = (UniquenessEnforcerNode)entity).getParents().isEmpty()) {
            return this.theme.getNodeColor(2);
        }
        return null;
    }

    public Color getForegroundColour(Object entity) {
        UniquenessEnforcerNode inputNode;
        if (entity instanceof Indexer) {
            return this.theme.getTextColor(0);
        }
        if (entity instanceof RetePatternMatcher) {
            return this.theme.getTextColor(1);
        }
        if (entity instanceof UniquenessEnforcerNode && (inputNode = (UniquenessEnforcerNode)entity).getParents().isEmpty()) {
            return this.theme.getTextColor(2);
        }
        return null;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }
}

