/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.CompositeJob;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.specific.job.EventAtomEditingDomainProvider;

public class RecordingJob<EventAtom>
extends CompositeJob<EventAtom> {
    public static final String TRANSACTIONAL_EDITING_DOMAIN = "org.eclipse.incquery.evm.TransactionalEditingDomain";
    public static final String RECORDING_JOB = "org.eclipse.incquery.evm.specifc.RecordingJobExecution";
    public static final String RECORDING_JOB_SESSION_DATA_KEY = "org.eclipse.incquery.evm.specific.RecordingJob.SessionData";
    private final EventAtomEditingDomainProvider<EventAtom> provider;

    public RecordingJob(Job<EventAtom> recordedJob) {
        super(recordedJob);
        this.provider = null;
    }

    public RecordingJob(Job<EventAtom> recordedJob, EventAtomEditingDomainProvider<EventAtom> provider) {
        super(recordedJob);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)"Provider cannot be null!");
        this.provider = provider;
    }

    @Override
    protected void execute(final Activation<? extends EventAtom> activation, final Context context) {
        Object target = this.findDomainTarget(activation, context);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)target);
        if (domain == null) {
            super.execute(activation, context);
        } else {
            RecordingCommand command = new RecordingCommand(domain){

                protected void doExecute() {
                    RecordingJob.super.execute(activation, context);
                }
            };
            command.setLabel(RECORDING_JOB);
            domain.getCommandStack().execute((Command)command);
            this.updateSessionData(activation, context, (Command)command);
        }
    }

    protected Object findDomainTarget(Activation<? extends EventAtom> activation, Context context) {
        Object domainTarget = context.get(TRANSACTIONAL_EDITING_DOMAIN);
        if (domainTarget == null && this.provider != null) {
            domainTarget = this.provider.findEditingDomain(activation, context);
        }
        return domainTarget;
    }

    private void updateSessionData(Activation<? extends EventAtom> activation, Context context, Command command) {
        Object data = context.get(RECORDING_JOB_SESSION_DATA_KEY);
        RecordingJobContextData result = null;
        if (data instanceof RecordingJobContextData) {
            result = (RecordingJobContextData)data;
        } else {
            result = new RecordingJobContextData();
            context.put(RECORDING_JOB_SESSION_DATA_KEY, result);
        }
        result.getTable().put(activation, (Object)this, (Object)command);
    }

    public static class RecordingJobContextData {
        private final Table<Activation<?>, RecordingJob<?>, Command> table = HashBasedTable.create();

        public Table<Activation<?>, RecordingJob<?>, Command> getTable() {
            return this.table;
        }
    }
}

