/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.incquery.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.incquery.databinding.runtime.collection.ObservableCollectionProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.Direction;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.ActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;
import org.eclipse.incquery.runtime.evm.specific.lifecycle.DefaultActivationLifeCycle;

public final class ObservableCollectionHelper {
    private ObservableCollectionHelper() {
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, IQuerySpecification<Matcher> querySpecification) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT_NO_UPDATE, jobs);
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, Matcher matcher) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newMatcherRuleSpecification(matcher, (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT_NO_UPDATE, jobs);
    }

    private static <Match extends IPatternMatch> Set<Job<Match>> getObservableCollectionJobs(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate) {
        Job insertJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.APPEARED, new ObservableCollectionProcessor<Match>(Direction.INSERT, observableCollectionUpdate)));
        Job deleteJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.DISAPPEARED, new ObservableCollectionProcessor<Match>(Direction.DELETE, observableCollectionUpdate)));
        return ImmutableSet.of((Object)insertJob, (Object)deleteJob);
    }

    public static <Match extends IPatternMatch> void prepareRuleEngine(IncQueryEngine engine, RuleSpecification<Match> specification, Match filter) {
        ExecutionSchema ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
        if (filter != null) {
            EventFilter matchFilter = Rules.newSingleMatchFilter(filter);
            ruleEngine.addRule(specification, matchFilter);
            ObservableCollectionHelper.fireActivations((RuleEngine)ruleEngine, specification, matchFilter);
        } else {
            ruleEngine.addRule(specification);
            ObservableCollectionHelper.fireActivations((RuleEngine)ruleEngine, specification, specification.createEmptyFilter());
        }
    }

    public static <Match extends IPatternMatch> void prepareRuleEngine(IncQueryEngine engine, RuleSpecification<Match> specification, Collection<Match> multifilters, IncQueryFilterSemantics semantics) {
        ExecutionSchema ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
        if (multifilters != null) {
            EventFilter matchFilter = Rules.newMultiMatchFilter(multifilters, (IncQueryFilterSemantics)semantics);
            ruleEngine.addRule(specification, matchFilter);
            ObservableCollectionHelper.fireActivations((RuleEngine)ruleEngine, specification, matchFilter);
        } else {
            ruleEngine.addRule(specification);
            ObservableCollectionHelper.fireActivations((RuleEngine)ruleEngine, specification, specification.createEmptyFilter());
        }
    }

    static <Match extends IPatternMatch> void fireActivations(RuleEngine ruleEngine, RuleSpecification<Match> specification, EventFilter<Match> filter) {
        Set activations = ruleEngine.getActivations(specification, filter);
        Context context = Context.create();
        for (Activation activation : activations) {
            activation.fire(context);
        }
    }
}

