/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.XmiModelUtil;
import org.eclipse.incquery.runtime.util.XmiModelUtilRunningOptionEnum;

public abstract class BaseGeneratedQuerySpecification<Matcher extends IncQueryMatcher<? extends IPatternMatch>>
extends BaseQuerySpecification<Matcher> {
    private static Map<String, PatternModel> bundleNameToPatternModelMap = new HashMap<String, PatternModel>();
    private static Map<String, Resource> bundleNameToResourceMap = new HashMap<String, Resource>();
    private final Pattern pattern = this.parsePattern();

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    protected abstract String getBundleName();

    protected abstract String patternName();

    protected Pattern parsePattern() throws IncQueryException {
        if (!Platform.isRunning()) {
            throw new IncQueryException("Generated EMF-IncQuery patterns cannot be used in standalone Java applications, for now we need the Eclipse Platform running", "Eclipse Platform not running");
        }
        PatternModel model = BaseGeneratedQuerySpecification.getModelRoot(this.getBundleName());
        try {
            return this.findPattern(model, this.patternName());
        }
        catch (Exception ex) {
            throw new IncQueryException("Unable to parse the definition of generated pattern " + this.patternName() + " (see log for any errors that could have caused this)", "Could not parse pattern definition.", ex);
        }
    }

    private Pattern findPattern(PatternModel model, String patternName) {
        if (model == null) {
            return null;
        }
        for (Pattern pattern : model.getPatterns()) {
            if (!pattern.getName().equals(patternName)) continue;
            return pattern;
        }
        return null;
    }

    public static PatternModel getModelRoot(String bundleName) throws IncQueryException {
        if (bundleName == null || bundleName.isEmpty()) {
            return null;
        }
        if (bundleNameToPatternModelMap.get(bundleName) == null) {
            Resource bundleResource = bundleNameToResourceMap.get(bundleName);
            if (bundleResource == null) {
                bundleResource = XmiModelUtil.getGlobalXmiResource(XmiModelUtilRunningOptionEnum.JUST_PLUGIN, bundleName);
                if (bundleResource == null) {
                    return null;
                }
                bundleNameToResourceMap.put(bundleName, bundleResource);
            }
            bundleNameToPatternModelMap.put(bundleName, (PatternModel)bundleResource.getContents().get(0));
        }
        return bundleNameToPatternModelMap.get(bundleName);
    }

    protected static void processInitializerError(ExceptionInInitializerError err) throws IncQueryException {
        Throwable cause2;
        Throwable cause1 = err.getCause();
        if (cause1 instanceof RuntimeException && (cause2 = ((RuntimeException)cause1).getCause()) instanceof IncQueryException) {
            throw (IncQueryException)cause2;
        }
    }
}

