/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime.annotation;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.incquery.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.validation.IIssueCallback;

public class ConstraintAnnotationValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.incquery.validation.";
    public static final String SEVERITY_ISSUE_CODE = "org.eclipse.incquery.validation.severity";
    @Inject
    private AnnotationExpressionValidator expressionValidator;

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        String value;
        ValueReference severityRef;
        Pattern pattern = (Pattern)annotation.eContainer();
        ValueReference messageRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"message");
        if (messageRef instanceof StringValue) {
            String value2 = ((StringValue)messageRef).getValue();
            this.expressionValidator.validateStringExpression(value2, pattern, messageRef, validator);
        }
        if ((severityRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"severity")) instanceof StringValue && !(value = ((StringValue)severityRef).getValue()).equals("error") && !value.equals("warning")) {
            validator.error("Severity must be either 'error' or 'warning'.", (EObject)severityRef, null, SEVERITY_ISSUE_CODE, new String[0]);
        }
    }
}

