/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;

public class StructuralFeatureCheck
extends CheckOperation {
    Integer sourcePosition;
    Integer targetPosition;
    EStructuralFeature feature;

    public StructuralFeatureCheck(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        try {
            EObject source = (EObject)frame.getValue(this.sourcePosition);
            Object target = frame.getValue(this.targetPosition);
            if (this.feature.isMany()) {
                return ((Collection)source.eGet(this.feature)).contains(target);
            }
            return target.equals(source.eGet(this.feature));
        }
        catch (ClassCastException e) {
            throw new LocalSearchException("Invalid type of variable", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StructuralFeatureCheck(");
        builder.append(this.sourcePosition + ", " + this.targetPosition + ", ");
        String name = this.feature.getName();
        EClass container = this.feature.getEContainingClass();
        String packageNsUri = container.getEPackage().getNsURI();
        builder.append("getFeatureLiteral(\"" + packageNsUri + "\", \"" + container.getName() + "\", \"" + name + "\")");
        builder.append(")");
        return builder.toString();
    }
}

