/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.impl.BasePatternGroup;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;

public class PackageBasedPatternGroup
extends BasePatternGroup {
    private final Set<IQuerySpecification<?>> querySpecifications = new HashSet();
    private final String packageName;
    private final boolean includeSubPackages;

    public PackageBasedPatternGroup(String packageName) {
        this(packageName, false);
    }

    public PackageBasedPatternGroup(String packageName, boolean includeSubPackages) {
        this.packageName = packageName;
        this.includeSubPackages = includeSubPackages;
        this.refresh();
    }

    @Override
    public Set<IQuerySpecification<?>> getSpecifications() {
        return this.getQuerySpecifications();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<IQuerySpecification<?>> getQuerySpecifications() {
        return this.querySpecifications;
    }

    public boolean isIncludeSubPackages() {
        return this.includeSubPackages;
    }

    public void refresh() {
        this.refreshInternal();
    }

    private void refreshInternal() {
        if (this.isIncludeSubPackages()) {
            this.querySpecifications.addAll(QuerySpecificationRegistry.getPatternSubTree(this.packageName));
        } else {
            this.querySpecifications.addAll(QuerySpecificationRegistry.getPatternGroup(this.packageName));
        }
    }
}

