/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.emf;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.base.api.DataTypeListener;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.IEClassifierProcessor;
import org.eclipse.incquery.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.incquery.runtime.base.api.InstanceListener;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.emf.EMFPatternMatcherContext;
import org.eclipse.incquery.runtime.internal.BaseIndexListener;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContextListener;

public class EMFPatternMatcherRuntimeContext
extends EMFPatternMatcherContext
implements IPatternMatcherRuntimeContext {
    private final NavigationHelper baseIndex;
    private BaseIndexListener listener;
    private final Set<EClass> classes = new HashSet<EClass>();
    private final Set<EDataType> dataTypes = new HashSet<EDataType>();
    private final Set<EStructuralFeature> features = new HashSet<EStructuralFeature>();

    public EMFPatternMatcherRuntimeContext(IncQueryEngine iqEngine, Logger logger, NavigationHelper baseIndex) {
        super(logger);
        this.baseIndex = baseIndex;
        this.listener = new BaseIndexListener(iqEngine);
    }

    public void ensure(EClass eClass) {
        if (this.classes.add(eClass)) {
            Set<EClass> newClasses = Collections.singleton(eClass);
            if (!this.baseIndex.isInWildcardMode()) {
                this.baseIndex.registerEClasses(newClasses);
            }
            this.baseIndex.addInstanceListener(newClasses, (InstanceListener)this.listener);
        }
    }

    public void ensure(EDataType eDataType) {
        if (this.dataTypes.add(eDataType)) {
            Set<EDataType> newDataTypes = Collections.singleton(eDataType);
            if (!this.baseIndex.isInWildcardMode()) {
                this.baseIndex.registerEDataTypes(newDataTypes);
            }
            this.baseIndex.addDataTypeListener(newDataTypes, (DataTypeListener)this.listener);
        }
    }

    public void ensure(EStructuralFeature feature) {
        if (this.features.add(feature)) {
            Set<EStructuralFeature> newFeatures = Collections.singleton(feature);
            if (!this.baseIndex.isInWildcardMode()) {
                this.baseIndex.registerEStructuralFeatures(newFeatures);
            }
            this.baseIndex.addFeatureListener(newFeatures, (FeatureListener)this.listener);
        }
    }

    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        return (V)this.baseIndex.coalesceTraversals(callable);
    }

    public void enumerateAllBinaryEdges(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllGeneralizations(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllInstantiations(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllTernaryEdges(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllUnaries(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllUnaryContainments(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateDirectBinaryEdgeInstances(Object typeObject, final IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        EStructuralFeature structural = (EStructuralFeature)typeObject;
        this.ensure(structural);
        this.baseIndex.processAllFeatureInstances(structural, new IEStructuralFeatureProcessor(){

            public void process(EStructuralFeature feature, EObject source, Object target) {
                crawler.crawl((Object)source, target);
            }
        });
    }

    public void enumerateAllBinaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        this.enumerateDirectBinaryEdgeInstances(typeObject, crawler);
    }

    public void enumerateDirectTernaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllTernaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateDirectUnaryInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        if (typeObject instanceof EClass) {
            EClass eClass = (EClass)typeObject;
            this.ensure(eClass);
            this.baseIndex.processDirectInstances(eClass, (IEClassifierProcessor.IEClassProcessor)new ClassCrawler(crawler));
        } else if (typeObject instanceof EDataType) {
            EDataType eDataType = (EDataType)typeObject;
            this.ensure(eDataType);
            this.baseIndex.processDataTypeInstances(eDataType, (IEClassifierProcessor.IEDataTypeProcessor)new DataTypeCrawler(crawler));
        } else {
            throw new IllegalArgumentException("typeObject has invalid type " + typeObject.getClass().getName());
        }
    }

    public void enumerateAllUnaryInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        if (typeObject instanceof EClass) {
            EClass eClass = (EClass)typeObject;
            this.ensure(eClass);
            this.baseIndex.processAllInstances(eClass, (IEClassifierProcessor.IEClassProcessor)new ClassCrawler(crawler));
        } else if (typeObject instanceof EDataType) {
            EDataType eDataType = (EDataType)typeObject;
            this.ensure(eDataType);
            this.baseIndex.processDataTypeInstances(eDataType, (IEClassifierProcessor.IEDataTypeProcessor)new DataTypeCrawler(crawler));
        } else {
            throw new IllegalArgumentException("typeObject has invalid type " + typeObject.getClass().getName());
        }
    }

    public void modelReadLock() {
    }

    public void modelReadUnLock() {
    }

    public void subscribeBackendForUpdates(IPatternMatcherRuntimeContextListener contextListener) {
        this.listener.addListener(contextListener);
    }

    public void unSubscribeBackendFromUpdates(IPatternMatcherRuntimeContextListener contextListener) {
        this.listener.removeListener(contextListener);
    }

    public Object ternaryEdgeSource(Object relation) {
        throw new UnsupportedOperationException();
    }

    public Object ternaryEdgeTarget(Object relation) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.baseIndex.removeFeatureListener(this.features, (FeatureListener)this.listener);
        this.features.clear();
        this.baseIndex.removeInstanceListener(this.classes, (InstanceListener)this.listener);
        this.classes.clear();
        this.baseIndex.removeDataTypeListener(this.dataTypes, (DataTypeListener)this.listener);
        this.dataTypes.clear();
    }

    private final class ClassCrawler
    implements IEClassifierProcessor.IEClassProcessor {
        private final IPatternMatcherRuntimeContext.ModelElementCrawler crawler;

        private ClassCrawler(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
            this.crawler = crawler;
        }

        public void process(EClass type, EObject instance) {
            this.crawler.crawl((Object)instance);
        }
    }

    private final class DataTypeCrawler
    implements IEClassifierProcessor.IEDataTypeProcessor {
        private final IPatternMatcherRuntimeContext.ModelElementCrawler crawler;

        private DataTypeCrawler(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
            this.crawler = crawler;
        }

        public void process(EDataType type, Object instance) {
            this.crawler.crawl(instance);
        }
    }
}

