/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.views;

import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.HorizontalShiftAlgorithm;
import org.eclipse.gef4.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SpaceTreeLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.gef4.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.tooling.ui.retevis.Activator;
import org.eclipse.incquery.tooling.ui.retevis.theme.ColorTheme;
import org.eclipse.incquery.tooling.ui.retevis.views.ZestReteContentProvider;
import org.eclipse.incquery.tooling.ui.retevis.views.ZestReteLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ReteVisView
extends ViewPart
implements IZoomableWorkbenchPart {
    public static final String ID = "org.eclipse.incquery.tooling.ui.retevis.views.ReteVisView";
    private GraphViewer graphViewer;
    private ColorTheme theme;
    private Action refreshGraph = new Action("Refresh Graph"){

        public void run() {
            ReteVisView.this.redraw();
        }
    };
    private Action clearGraph = new Action("Clear Graph"){

        public void run() {
            ReteVisView.this.graphViewer.setInput(null);
        }
    };

    public AbstractZoomableViewer getZoomableViewer() {
        return this.graphViewer;
    }

    public static ReteVisView getInstance() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
            return (ReteVisView)activeWorkbenchWindow.getActivePage().findView(ID);
        }
        return null;
    }

    public void redraw() {
        if (this.graphViewer != null) {
            this.graphViewer.applyLayout();
        }
    }

    private void initializeActions() {
        this.refreshGraph.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.incquery.tooling.ui.retevis", (String)"icons/refresh.gif"));
        this.clearGraph.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.incquery.tooling.ui.retevis", (String)"icons/clear.gif"));
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.removeAll();
        mgr.add((IAction)this.refreshGraph);
        mgr.add((IAction)this.clearGraph);
        ZoomContributionViewItem toolbarZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        mgr.add((IContributionItem)toolbarZoomContributionViewItem);
        mgr.update(true);
        IMenuManager mmgr = this.getViewSite().getActionBars().getMenuManager();
        mmgr.removeAll();
        mmgr.add((IContributionItem)this.createLayoutMenu());
    }

    private MenuManager createLayoutMenu() {
        MenuManager mgr = new MenuManager("Layout");
        mgr.add((IAction)this.createLayoutAction("Tree", (LayoutAlgorithm)new TreeLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Spring", (LayoutAlgorithm)new SpringLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("Radial", (LayoutAlgorithm)new RadialLayoutAlgorithm()));
        mgr.add((IAction)this.createLayoutAction("SpaceTree", (LayoutAlgorithm)new SpaceTreeLayoutAlgorithm()));
        SugiyamaLayoutAlgorithm sugiyamaAlgorithm = new SugiyamaLayoutAlgorithm();
        HorizontalShiftAlgorithm shiftAlgorithm = new HorizontalShiftAlgorithm();
        mgr.add((IAction)this.createLayoutAction("Sugiyama (unstable)", (LayoutAlgorithm)new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{sugiyamaAlgorithm, shiftAlgorithm})));
        return mgr;
    }

    private Action createLayoutAction(String name, final LayoutAlgorithm lay) {
        return new Action(name){

            public void run() {
                ReteVisView.this.graphViewer.setLayoutAlgorithm(lay);
                ReteVisView.this.redraw();
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.graphViewer = new GraphViewer(parent, 2048);
        this.graphViewer.setConnectionStyle(2);
        this.graphViewer.setContentProvider((IContentProvider)new ZestReteContentProvider());
        ZestReteLabelProvider labelProvider = new ZestReteLabelProvider();
        Display display = parent.getDisplay();
        this.theme = new ColorTheme(display);
        labelProvider.setColors(this.theme);
        this.graphViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.initializeActions();
        this.createToolbar();
    }

    public void setContent(ReteBoundary rb) {
        ((ZestReteLabelProvider)this.graphViewer.getLabelProvider()).setRb(rb);
        this.graphViewer.setLayoutAlgorithm((LayoutAlgorithm)new TreeLayoutAlgorithm());
        this.graphViewer.setInput((Object)rb.getHeadContainer());
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.theme != null) {
            this.theme.dispose();
        }
        super.dispose();
    }
}

