/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.ui.util.IWorkspaceUtilities;
import org.eclipse.incquery.patternlanguage.emf.util.SimpleClassLoaderProvider;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

@Singleton
public class JavaProjectClassLoaderProvider
extends SimpleClassLoaderProvider
implements IWorkspaceUtilities {
    @Inject
    private IWorkspaceRoot root;

    public ClassLoader getClassLoader(Pattern pattern) throws IncQueryException {
        try {
            ClassLoader l;
            IFile file = this.getIFile(pattern);
            if (file != null && file.exists()) {
                l = this.getClassLoader(file);
                if (l == null) {
                    throw new IncQueryException(String.format("No classloader found for pattern %s.", CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern)), "No classloader found.");
                }
            } else {
                l = super.getClassLoader(pattern);
            }
            return l;
        }
        catch (Exception e) {
            throw new IncQueryException(String.format("Cannot initialize classloader for pattern %s because %s", CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern), e.getMessage()), "Cannot initialize classloader", (Throwable)e);
        }
    }

    @Override
    public IFile getIFile(Pattern pattern) {
        URI uri;
        String scheme;
        Resource resource;
        if (pattern != null && (resource = pattern.eResource()) != null && "platform".equals(scheme = (uri = resource.getURI()).scheme()) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(j));
                ++j;
            }
            return this.root.getFile((IPath)new Path(platformResourcePath.toString()));
        }
        return null;
    }

    public ClassLoader getClassLoader(IFile file) throws CoreException, MalformedURLException {
        if (file != null && file.exists()) {
            IProject project = file.getProject();
            IJavaProject jp = JavaCore.create((IProject)project);
            String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)jp);
            List<URL> classURLs = this.getClassesAsURLs(classPathEntries);
            URL[] urls = classURLs.toArray(new URL[classURLs.size()]);
            URLClassLoader loader = URLClassLoader.newInstance(urls, jp.getClass().getClassLoader());
            return loader;
        }
        return null;
    }

    private List<URL> getClassesAsURLs(String[] classPathEntries) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        int i = 0;
        while (i < classPathEntries.length) {
            String entry = classPathEntries[i];
            Path path = new Path(entry);
            URL url = path.toFile().toURI().toURL();
            urlList.add(url);
            ++i;
        }
        return urlList;
    }
}

