/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguageFactory;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguageFactory;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.wizards.NewEiqFileWizardContainerConfigurationPage;
import org.eclipse.incquery.tooling.ui.wizards.NewEiqFileWizardPatternConfigurationPage;
import org.eclipse.incquery.tooling.ui.wizards.internal.ObjectParameter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class NewEiqFileWizard
extends Wizard
implements INewWizard {
    private static final String NEW_EMF_INC_QUERY_QUERY_DEFINITION_FILE = "Create a new EMF-IncQuery Query Definition file.";
    private NewEiqFileWizardContainerConfigurationPage page1;
    private NewEiqFileWizardPatternConfigurationPage page2;
    private ISelection selection;
    private IWorkbench workbench;
    private final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    private IPath filePath;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private Injector injector;

    public NewEiqFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new NewEiqFileWizardContainerConfigurationPage();
        this.page1.init((IStructuredSelection)this.selection);
        this.page1.setDescription(NEW_EMF_INC_QUERY_QUERY_DEFINITION_FILE);
        this.page2 = new NewEiqFileWizardPatternConfigurationPage();
        this.injector.injectMembers((Object)this.page2);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        final String containerName = this.page1.getContainerName();
        final String fileName = this.page1.getFileName();
        final String packageName = this.page1.getPackageName().replaceAll("\\.", "/");
        final String patternName = this.page2.getPatternName();
        final List<EPackage> imports = this.page2.getImports();
        final List<ObjectParameter> parameters = this.page2.getParameters();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("Creating " + fileName, 1);
                        IFile file = NewEiqFileWizard.this.createEiqFile(containerName, fileName, packageName, patternName, imports, parameters);
                        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)NewEiqFileWizard.this.workbench.getActiveWorkbenchWindow());
                        IDE.openEditor((IWorkbenchPage)NewEiqFileWizard.this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            IncQueryGUIPlugin.getDefault().logException("Cannot create Query Definition file: " + realException.getMessage(), realException);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }

    private IFile createEiqFile(String containerName, String fileName, String packageName, String patternName, List<EPackage> imports, List<ObjectParameter> parameters) throws IOException, CoreException {
        IResource containerResource = this.root.findMember((IPath)new Path(containerName));
        ResourceSet resourceSet = this.resourceSetProvider.get(containerResource.getProject());
        this.filePath = containerResource.getFullPath().append(String.valueOf(packageName) + "/" + fileName);
        IFile file = this.root.getFile(this.filePath);
        String fullPath = this.filePath.toString();
        URI fileURI = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
        Resource resource = resourceSet.createResource(fileURI);
        PatternModel pm = EMFPatternLanguageFactory.eINSTANCE.createPatternModel();
        if (packageName != null && !packageName.isEmpty()) {
            pm.setPackageName(packageName.replace("/", "."));
        }
        pm.setImportPackages(EMFPatternLanguageFactory.eINSTANCE.createXImportSection());
        for (EPackage importedPackage : imports) {
            PackageImport importDecl = EMFPatternLanguageFactory.eINSTANCE.createPackageImport();
            importDecl.setEPackage(importedPackage);
            pm.getImportPackages().getPackageImport().add((Object)importDecl);
        }
        if (patternName != null && patternName.length() > 0) {
            Pattern pattern = PatternLanguageFactory.eINSTANCE.createPattern();
            pattern.setName(patternName);
            PatternBody body = PatternLanguageFactory.eINSTANCE.createPatternBody();
            pattern.getBodies().add((Object)body);
            for (ObjectParameter parameter : parameters) {
                Variable var = PatternLanguageFactory.eINSTANCE.createVariable();
                var.setName(parameter.getParameterName());
                ClassType classType = EMFPatternLanguageFactory.eINSTANCE.createClassType();
                classType.setClassname(parameter.getObject());
                var.setType((Type)classType);
                pattern.getParameters().add((Object)var);
            }
            pm.getPatterns().add((Object)pattern);
        }
        resource.getContents().add((Object)pm);
        resource.save(Collections.EMPTY_MAP);
        containerResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return file;
    }
}

