/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;

public class IncQueryMultiPatternMatchEventFilter<Match extends IPatternMatch>
implements EventFilter<Match> {
    private Collection<Match> filterMatches;
    private IncQueryFilterSemantics semantics;

    public Collection<Match> getFilterMatches() {
        return this.filterMatches;
    }

    @Override
    public boolean isProcessable(Match eventAtom) {
        if (this.filterMatches == null) {
            return true;
        }
        switch (this.semantics) {
            default: {
                for (IPatternMatch filterMatch : this.filterMatches) {
                    if (!filterMatch.isCompatibleWith(eventAtom)) continue;
                    return true;
                }
                return false;
            }
            case AND: 
        }
        for (IPatternMatch filterMatch : this.filterMatches) {
            if (filterMatch.isCompatibleWith(eventAtom)) continue;
            return false;
        }
        return true;
    }

    protected IncQueryMultiPatternMatchEventFilter(Collection<Match> filterMatches, IncQueryFilterSemantics semantics) {
        Preconditions.checkArgument((filterMatches != null ? 1 : 0) != 0, (Object)"Cannot create filter with null matches");
        this.semantics = semantics;
        this.filterMatches = filterMatches;
    }

    public static <Match extends IPatternMatch> IncQueryMultiPatternMatchEventFilter<Match> createFilter(Collection<Match> eventAtoms, IncQueryFilterSemantics semantics) {
        Preconditions.checkArgument((eventAtoms != null ? 1 : 0) != 0, (Object)"Cannot create filter for null match, use createEmptyFilter() instead!");
        for (IPatternMatch eventAtom : eventAtoms) {
            Preconditions.checkArgument((!eventAtom.isMutable() ? 1 : 0) != 0, (Object)"Cannot create filter for mutable match!");
        }
        return new IncQueryMultiPatternMatchEventFilter<Match>(eventAtoms, semantics);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.filterMatches});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncQueryMultiPatternMatchEventFilter other = (IncQueryMultiPatternMatchEventFilter)obj;
        return Objects.equal(this.filterMatches, other.filterMatches);
    }
}

