/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.tuple;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.tuple.Clearable;
import org.eclipse.incquery.runtime.rete.tuple.TupleMemory;

public class MaskedTupleMemory
implements Clearable,
Iterable<Tuple> {
    protected Map<Tuple, Collection<Tuple>> matchings;
    protected TupleMask mask;

    public MaskedTupleMemory(TupleMask mask) {
        this.mask = mask;
        this.matchings = CollectionsFactory.getMap();
    }

    public boolean add(Tuple ps) {
        Tuple signature = this.mask.transform(ps);
        return this.add(ps, signature);
    }

    public boolean add(Tuple ps, Tuple signature) {
        boolean change;
        TupleMemory coll = this.matchings.get(signature);
        boolean bl = change = coll == null;
        if (change) {
            coll = new TupleMemory();
            this.matchings.put(signature, coll);
        }
        if (!coll.add((Tuple)ps)) {
            throw new IllegalStateException();
        }
        return change;
    }

    public boolean remove(Tuple ps) {
        Tuple signature = this.mask.transform(ps);
        return this.remove(ps, signature);
    }

    public boolean remove(Tuple ps, Tuple signature) {
        Collection<Tuple> coll = this.matchings.get(signature);
        if (!coll.remove(ps)) {
            throw new IllegalStateException();
        }
        boolean change = coll.isEmpty();
        if (change) {
            this.matchings.remove(signature);
        }
        return change;
    }

    public Collection<Tuple> get(Tuple signature) {
        return this.matchings.get(signature);
    }

    @Override
    public void clear() {
        this.matchings.clear();
    }

    public Collection<Tuple> getSignatures() {
        return this.matchings.keySet();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new MaskedPatternIterator(this);
    }

    public String toString() {
        return "MTM<" + this.mask + "|" + this.matchings + ">";
    }

    public int getTotalSize() {
        int i = 0;
        for (Collection<Tuple> v : this.matchings.values()) {
            i += v.size();
        }
        return i;
    }

    public int getKeysetSize() {
        return this.matchings.keySet().size();
    }

    class MaskedPatternIterator
    implements Iterator<Tuple> {
        Iterator<Collection<Tuple>> signatureGroup;
        Iterator<Tuple> element;

        public MaskedPatternIterator(MaskedTupleMemory memory) {
            this.signatureGroup = memory.matchings.values().iterator();
            Set emptySet = Collections.emptySet();
            this.element = emptySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.element.hasNext() || this.signatureGroup.hasNext();
        }

        @Override
        public Tuple next() throws NoSuchElementException {
            if (this.element.hasNext()) {
                return this.element.next();
            }
            if (this.signatureGroup.hasNext()) {
                this.element = this.signatureGroup.next().iterator();
                return this.element.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }
}

