/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.core;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.emf.helper.IncQueryRuntimeHelper;
import org.eclipse.incquery.validation.core.Constraint;
import org.eclipse.incquery.validation.core.Violation;
import org.eclipse.incquery.validation.core.violationkey.ViolationKey;

public class ViolationCreationProcessor
implements IMatchProcessor<IPatternMatch> {
    private Constraint constraint;
    private Map<ViolationKey, Violation> violationMap;
    private Logger logger;

    public ViolationCreationProcessor(Constraint constraint, Logger logger, Map<ViolationKey, Violation> violationMap) {
        this.constraint = constraint;
        this.logger = logger;
        this.violationMap = violationMap;
    }

    public void process(IPatternMatch match) {
        Map<String, Object> keyObjectMap = this.constraint.getSpecification().getKeyObjects(match);
        if (!keyObjectMap.isEmpty()) {
            ViolationKey key = this.constraint.getViolationKey(match);
            Violation violation = this.violationMap.get(key);
            if (violation == null) {
                violation = new Violation();
                violation.setConstraint(this.constraint);
                violation.setKeyObjects(this.constraint.getSpecification().getKeyObjects(match));
                violation.setMessage(IncQueryRuntimeHelper.getMessage((IPatternMatch)match, (String)this.constraint.getSpecification().getMessageFormat()));
                this.violationMap.put(key, violation);
            }
            violation.addMatch(match);
        } else {
            this.logger.error((Object)"Error getting Violation key objects!");
        }
    }
}

