/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngineInitializationListener;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.internal.apiimpl.IncQueryEngineImpl;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class IncQueryEngineManager {
    private static IncQueryEngineManager instance = new IncQueryEngineManager();
    Map<IncQueryScope, WeakReference<IncQueryEngineImpl>> engines = new WeakHashMap<IncQueryScope, WeakReference<IncQueryEngineImpl>>();
    private final Set<IncQueryEngineInitializationListener> initializationListeners = new HashSet<IncQueryEngineInitializationListener>();

    public static IncQueryEngineManager getInstance() {
        return instance;
    }

    IncQueryEngineManager() {
    }

    public IncQueryEngine getIncQueryEngine(IncQueryScope scope) throws IncQueryException {
        IncQueryEngineImpl engine = this.getEngineInternal(scope);
        if (engine == null) {
            engine = new IncQueryEngineImpl(this, scope);
            this.engines.put(scope, new WeakReference<IncQueryEngineImpl>(engine));
            this.notifyInitializationListeners(engine);
        }
        return engine;
    }

    public IncQueryEngine getIncQueryEngineIfExists(IncQueryScope scope) {
        return this.getEngineInternal(scope);
    }

    public Set<IncQueryEngine> getExistingIncQueryEngines() {
        HashSet existingEngines = null;
        for (WeakReference<IncQueryEngineImpl> engineRef : this.engines.values()) {
            IncQueryEngineImpl engine;
            IncQueryEngineImpl incQueryEngineImpl = engine = engineRef == null ? null : (IncQueryEngineImpl)engineRef.get();
            if (existingEngines == null) {
                existingEngines = Sets.newHashSet();
            }
            existingEngines.add(engine);
        }
        if (existingEngines == null) {
            existingEngines = Collections.emptySet();
        }
        return existingEngines;
    }

    public void addIncQueryEngineInitializationListener(IncQueryEngineInitializationListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        this.initializationListeners.add(listener);
    }

    public void removeIncQueryEngineInitializationListener(IncQueryEngineInitializationListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        this.initializationListeners.remove(listener);
    }

    protected void notifyInitializationListeners(AdvancedIncQueryEngine engine) {
        try {
            if (!this.initializationListeners.isEmpty()) {
                for (IncQueryEngineInitializationListener listener : Sets.newHashSet(this.initializationListeners)) {
                    listener.engineInitialized(engine);
                }
            }
        }
        catch (Exception ex) {
            IncQueryLoggingUtil.getLogger(this.getClass()).fatal((Object)"IncQuery Engine Manager encountered an error in delivering notifications about engine initialization. ", (Throwable)ex);
        }
    }

    private IncQueryEngineImpl getEngineInternal(IncQueryScope scope) {
        WeakReference<IncQueryEngineImpl> engineRef = this.engines.get(scope);
        IncQueryEngineImpl engine = engineRef == null ? null : (IncQueryEngineImpl)engineRef.get();
        return engine;
    }
}

