package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ClassExtensionMatch;
import org.eclipse.uml2.uml.Extension;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.classExtension pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ClassExtensionProcessor implements IMatchProcessor<ClassExtensionMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final org.eclipse.uml2.uml.Class pSource, final Extension pTarget);
  
  @Override
  public void process(final ClassExtensionMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
