/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchCollection;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchSet;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;

public class ObservablePatternMatchCollectionBuilder<M extends IPatternMatch> {
    private IQuerySpecification<? extends IncQueryMatcher<M>> specification = null;
    private EventFilter<M> filter = null;
    private IncQueryEngine incQueryEngine = null;
    private RuleEngine ruleEngine = null;
    private Comparator<M> comparator = null;
    private Function<M, ?> converter = null;
    private IncQueryMatcher<M> matcher = null;

    public static <M extends IPatternMatch> ObservablePatternMatchCollectionBuilder<M> create(IQuerySpecification<? extends IncQueryMatcher<M>> specification) {
        ObservablePatternMatchCollectionBuilder<M> builder = new ObservablePatternMatchCollectionBuilder<M>(specification);
        return builder;
    }

    public static <M extends IPatternMatch> ObservablePatternMatchCollectionBuilder<M> create(IncQueryMatcher<M> matcher) {
        ObservablePatternMatchCollectionBuilder<M> builder = new ObservablePatternMatchCollectionBuilder<M>(matcher);
        return builder;
    }

    protected ObservablePatternMatchCollectionBuilder(IQuerySpecification<? extends IncQueryMatcher<M>> specification) {
        this.specification = specification;
    }

    protected ObservablePatternMatchCollectionBuilder(IncQueryMatcher<M> matcher) {
        this.matcher = matcher;
        this.incQueryEngine = matcher.getEngine();
    }

    public ObservablePatternMatchCollectionBuilder<M> setFilter(EventFilter<M> filter) {
        this.filter = filter;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setFilter(M filter) {
        this.filter = Rules.newSingleMatchFilter(filter);
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setFilter(Collection<M> multifilters, IncQueryFilterSemantics semantics) {
        this.filter = Rules.newMultiMatchFilter(multifilters, (IncQueryFilterSemantics)semantics);
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setEngine(IncQueryEngine engine) {
        this.incQueryEngine = engine;
        this.ruleEngine = null;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setEngine(RuleEngine engine) {
        this.ruleEngine = engine;
        this.incQueryEngine = null;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setComparator(Comparator<M> comparator) {
        this.comparator = comparator;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setConverter(Function<M, ?> converter) {
        this.converter = converter;
        return this;
    }

    public ObservablePatternMatchList<M> buildList() {
        this.checkBuilderConfiguration();
        ObservablePatternMatchList observable = new ObservablePatternMatchList();
        ObservablePatternMatchCollection collection = observable.getInternalCollection();
        this.buildCollection(collection);
        return observable;
    }

    public ObservablePatternMatchSet<M> buildSet() {
        this.checkBuilderConfiguration();
        Preconditions.checkState((this.comparator == null ? 1 : 0) != 0, (Object)"Cannot use comparator in set!");
        ObservablePatternMatchSet observable = new ObservablePatternMatchSet();
        ObservablePatternMatchCollection collection = observable.getInternalCollection();
        this.buildCollection(collection);
        return observable;
    }

    private void checkBuilderConfiguration() {
        Preconditions.checkState((this.ruleEngine != null || this.incQueryEngine != null ? 1 : 0) != 0, (Object)"(IncQuery or Rule) Engine not set!");
        Preconditions.checkState((this.specification != null || this.matcher != null ? 1 : 0) != 0, (Object)"Matcher or QuerySpecification not set!");
    }

    private void buildCollection(ObservablePatternMatchCollection<M> collection) {
        collection.createUpdater(this.converter, this.comparator);
        if (this.specification == null) {
            collection.createRuleSpecification(this.matcher);
        } else {
            collection.createRuleSpecification(this.specification);
        }
        collection.setFilter(this.filter);
        if (this.ruleEngine != null) {
            collection.initialize(this.ruleEngine);
        } else {
            collection.initialize(this.incQueryEngine);
        }
    }
}

