/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.comprehension;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class WellbehavingDerivedFeatureRegistry {
    private static Collection<EStructuralFeature> contributedWellbehavingDerivedFeatures = new ArrayList<EStructuralFeature>();
    private static Collection<EClass> contributedWellbehavingDerivedClasses = new ArrayList<EClass>();
    private static Collection<EPackage> contributedWellbehavingDerivedPackages = new ArrayList<EPackage>();

    private WellbehavingDerivedFeatureRegistry() {
    }

    public static void initRegistry() {
        WellbehavingDerivedFeatureRegistry.getContributedWellbehavingDerivedFeatures().clear();
        WellbehavingDerivedFeatureRegistry.getContributedWellbehavingDerivedClasses().clear();
        WellbehavingDerivedFeatureRegistry.getContributedWellbehavingDerivedPackages().clear();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint("org.eclipse.incquery.runtime.base.wellbehaving.derived.features");
        if (poi != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = poi.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] els;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = els = ext.getConfigurationElements();
                int n3 = els.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (!el.getName().equals("wellbehaving-derived-feature")) {
                        throw new UnsupportedOperationException("Unknown configuration element " + el.getName() + " in plugin.xml of " + el.getDeclaringExtension().getUniqueIdentifier());
                    }
                    WellbehavingDerivedFeatureRegistry.processWellbehavingExtension(el);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static void processWellbehavingExtension(IConfigurationElement el) {
        try {
            EPackage pckg;
            String packageUri = el.getAttribute("package-nsUri");
            String classifierName = el.getAttribute("classifier-name");
            String featureName = el.getAttribute("feature-name");
            if (packageUri != null && (pckg = EPackage.Registry.INSTANCE.getEPackage(packageUri)) != null) {
                if (classifierName != null) {
                    EClassifier clsr = pckg.getEClassifier(classifierName);
                    if (clsr instanceof EClass) {
                        if (featureName != null) {
                            EClass cls = (EClass)clsr;
                            EStructuralFeature feature = cls.getEStructuralFeature(featureName);
                            if (feature != null) {
                                contributedWellbehavingDerivedFeatures.add(feature);
                            }
                        } else {
                            contributedWellbehavingDerivedClasses.add((EClass)clsr);
                        }
                    }
                } else {
                    contributedWellbehavingDerivedPackages.add(pckg);
                }
            }
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(WellbehavingDerivedFeatureRegistry.class);
            logger.error((Object)"Well-behaving feature registration failed", (Throwable)e);
        }
    }

    public static void registerWellbehavingDerivedFeature(EStructuralFeature feature) {
        contributedWellbehavingDerivedFeatures.add(feature);
    }

    public static void registerWellbehavingDerivedClass(EClass cls) {
        contributedWellbehavingDerivedClasses.add(cls);
    }

    public static void registerWellbehavingDerivedPackage(EPackage pkg) {
        contributedWellbehavingDerivedPackages.add(pkg);
    }

    public static Collection<EStructuralFeature> getContributedWellbehavingDerivedFeatures() {
        return contributedWellbehavingDerivedFeatures;
    }

    public static Collection<EClass> getContributedWellbehavingDerivedClasses() {
        return contributedWellbehavingDerivedClasses;
    }

    public static Collection<EPackage> getContributedWellbehavingDerivedPackages() {
        return contributedWellbehavingDerivedPackages;
    }

    public static boolean isWellbehavingFeature(EStructuralFeature feature) {
        if (contributedWellbehavingDerivedFeatures.contains(feature)) {
            return true;
        }
        if (contributedWellbehavingDerivedClasses.contains(feature.getEContainingClass())) {
            return true;
        }
        return contributedWellbehavingDerivedPackages.contains(feature.getEContainingClass().getEPackage());
    }
}

