/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.evm.notification.AttributeMonitor;

public class LightweightAttributeMonitor<MatchType extends IPatternMatch>
extends AttributeMonitor<MatchType> {
    private LightweightEObjectObserver observer;
    private Multimap<EObject, MatchType> observedMultimap;
    private NavigationHelper navigationHelper;

    public LightweightAttributeMonitor(NavigationHelper helper) {
        this.navigationHelper = helper;
        this.observer = new LightweightEObjectObserver(){

            public void notifyFeatureChanged(EObject host, EStructuralFeature feature, Notification notification) {
                Collection matches = LightweightAttributeMonitor.this.observedMultimap.get((Object)host);
                for (IPatternMatch matchType : matches) {
                    LightweightAttributeMonitor.this.notifyListeners(matchType);
                }
            }
        };
        this.observedMultimap = HashMultimap.create();
    }

    @Override
    public void registerFor(MatchType atom) {
        Collection<EObject> allEObjects = this.findAllEObjects(atom);
        for (EObject eObject : allEObjects) {
            this.navigationHelper.addLightweightEObjectObserver(this.observer, eObject);
            this.observedMultimap.put((Object)eObject, atom);
        }
    }

    @Override
    public void unregisterForAll() {
        for (EObject eobj : this.observedMultimap.keySet()) {
            this.navigationHelper.removeLightweightEObjectObserver(this.observer, eobj);
        }
    }

    @Override
    public void unregisterFor(MatchType atom) {
        Collection<EObject> allEObjects = this.findAllEObjects(atom);
        for (EObject eObject : allEObjects) {
            this.navigationHelper.removeLightweightEObjectObserver(this.observer, eObject);
            this.observedMultimap.remove((Object)eObject, atom);
        }
    }

    private Collection<EObject> findAllEObjects(MatchType atom) {
        ArrayList eobjs = Lists.newArrayList();
        for (String param : atom.parameterNames()) {
            Object location = atom.get(param);
            if (!(location instanceof EObject)) continue;
            eobjs.add((EObject)location);
        }
        return eobjs;
    }
}

