/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.planning.operations;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.operations.POperation;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;

public class PProject
extends POperation {
    private Collection<PVariable> toVariables;
    private boolean ordered;

    public PProject(Set<PVariable> toVariables) {
        this.toVariables = toVariables;
        this.ordered = false;
    }

    public PProject(List<PVariable> toVariables) {
        this.toVariables = toVariables;
        this.ordered = true;
    }

    public Collection<PVariable> getToVariables() {
        return this.toVariables;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Set<? extends PConstraint> getDeltaConstraints() {
        return Collections.emptySet();
    }

    @Override
    public int numParentSubPlans() {
        return 1;
    }

    @Override
    public void checkConsistency(SubPlan subPlan) {
        super.checkConsistency(subPlan);
        SubPlan parentPlan = subPlan.getParentPlans().get(0);
        Preconditions.checkArgument((boolean)parentPlan.getVisibleVariables().containsAll(this.toVariables), (Object)("Variables missing from project: " + Joiner.on((char)',').join((Iterable)Sets.difference(new HashSet<PVariable>(this.toVariables), parentPlan.getVisibleVariables()))));
    }

    @Override
    public String getShortName() {
        return String.format("PROJECT%s_{%s}", this.ordered ? "!" : "", Joiner.on((String)",").join(this.toVariables));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ordered ? 1231 : 1237);
        result = 31 * result + (this.toVariables == null ? 0 : this.toVariables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PProject)) {
            return false;
        }
        PProject other = (PProject)obj;
        if (this.ordered != other.ordered) {
            return false;
        }
        return !(this.toVariables == null ? other.toVariables != null : !this.toVariables.equals(other.toVariables));
    }
}

