/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicdeferred;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.psystem.IQueryReference;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.VariableDeferredPConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public abstract class PatternCallBasedDeferred
extends VariableDeferredPConstraint
implements IQueryReference {
    protected Tuple actualParametersTuple;
    protected PQuery query;
    private Set<PVariable> deferringVariables;

    protected abstract void doDoReplaceVariables(PVariable var1, PVariable var2);

    protected abstract Set<PVariable> getCandidateQuantifiedVariables();

    public PatternCallBasedDeferred(PBody pSystem, Tuple actualParametersTuple, PQuery pattern, Set<PVariable> additionalAffectedVariables) {
        super(pSystem, PatternCallBasedDeferred.union(actualParametersTuple.getDistinctElements(), additionalAffectedVariables));
        this.actualParametersTuple = actualParametersTuple;
        this.query = pattern;
    }

    public PatternCallBasedDeferred(PBody pSystem, Tuple actualParametersTuple, PQuery pattern) {
        this(pSystem, actualParametersTuple, pattern, Collections.emptySet());
    }

    private static Set<PVariable> union(Set<PVariable> a, Set<PVariable> b) {
        HashSet<PVariable> result = new HashSet<PVariable>();
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    @Override
    public Set<PVariable> getDeferringVariables() {
        if (this.deferringVariables == null) {
            this.deferringVariables = new HashSet<PVariable>();
            for (PVariable var : this.getCandidateQuantifiedVariables()) {
                if (!var.isDeducable()) continue;
                this.deferringVariables.add(var);
            }
        }
        return this.deferringVariables;
    }

    @Override
    public void checkSanity() throws QueryProcessingException {
        super.checkSanity();
        for (Object obj : this.actualParametersTuple.getDistinctElements()) {
            PVariable var = (PVariable)obj;
            if (this.getDeferringVariables().contains(var)) continue;
            for (PConstraint pConstraint : var.getReferringConstraints()) {
                if (pConstraint == this || pConstraint instanceof Equality && ((Equality)pConstraint).isMoot()) continue;
                throw new QueryProcessingException("Variable {1} of constraint {2} is not a positively determined part of the pattern, yet it is also affected by {3}.", new String[]{var.toString(), this.toString(), pConstraint.toString()}, "Read-only variable can not be deduced", null);
            }
        }
    }

    @Override
    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (this.deferringVariables != null) {
            throw new IllegalStateException("Cannot replace variables on " + this + " when deferring variables have already been identified.");
        }
        this.actualParametersTuple = this.actualParametersTuple.replaceAll(obsolete, replacement);
        this.doDoReplaceVariables(obsolete, replacement);
    }

    public Tuple getActualParametersTuple() {
        return this.actualParametersTuple;
    }

    @Override
    public PQuery getReferredQuery() {
        return this.query;
    }
}

