/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;

public class UnionFind<T>
implements Map<T, T> {
    protected Map<T, Node> nodes = CollectionsFactory.getMap();

    protected Node find(Node n) {
        if (n.parent == n) {
            return n;
        }
        n.parent = this.find(n.parent);
        return n.parent;
    }

    public T find(T x) {
        Node node = this.nodes.get(x);
        if (node == null) {
            return x;
        }
        return this.find((Node)node).value;
    }

    public boolean isRoot(T x) {
        Node node = this.nodes.get(x);
        if (node == null) {
            return true;
        }
        return node == node.parent;
    }

    protected Node retrieveOrCreate(T x) {
        Node node = this.nodes.get(x);
        if (node == null) {
            node = new Node(x);
            this.nodes.put(x, node);
            return node;
        }
        return this.find(node);
    }

    public void unite(T a, T b) {
        Node aRoot = this.retrieveOrCreate(a);
        Node bRoot = this.retrieveOrCreate(b);
        if (aRoot.rank > bRoot.rank) {
            bRoot.parent = aRoot;
        } else if (aRoot.rank < bRoot.rank) {
            aRoot.parent = bRoot;
        } else if (aRoot != bRoot) {
            bRoot.parent = aRoot;
            ++aRoot.rank;
        }
    }

    @Override
    public void clear() {
        this.nodes.clear();
    }

    @Override
    public T get(Object key) {
        return (T)this.find(key);
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<T, T>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<T> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T put(T key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends T, ? extends T> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<T> values() {
        throw new UnsupportedOperationException();
    }

    class Node {
        public T value;
        public Node parent;
        public int rank;

        public Node(T value) {
            this.value = value;
            this.parent = this;
            this.rank = 0;
        }
    }
}

