/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem;

import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.Buildable;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;

public class PSystem<PatternDescription, StubHandle, Collector> {
    private PatternDescription pattern;
    private IPatternMatcherContext<PatternDescription> context;
    private Buildable<PatternDescription, StubHandle, Collector> buildable;
    private Set<PVariable> allVariables;
    private Set<PVariable> uniqueVariables;
    private Map<Object, PVariable> variablesByName;
    private Set<PConstraint> constraints;
    private int nextVirtualNodeID;

    public PSystem(IPatternMatcherContext<PatternDescription> context, Buildable<PatternDescription, StubHandle, Collector> buildable, PatternDescription pattern) {
        this.pattern = pattern;
        this.context = context;
        this.buildable = buildable;
        this.allVariables = CollectionsFactory.getSet();
        this.uniqueVariables = CollectionsFactory.getSet();
        this.variablesByName = CollectionsFactory.getMap();
        this.constraints = CollectionsFactory.getSet();
    }

    private boolean addVariable(PVariable var) {
        Object name = var.getName();
        if (!this.variablesByName.containsKey(name)) {
            this.allVariables.add(var);
            if (var.isUnique()) {
                this.uniqueVariables.add(var);
            }
            this.variablesByName.put(name, var);
            return true;
        }
        return false;
    }

    boolean registerConstraint(PConstraint constraint) {
        return this.constraints.add(constraint);
    }

    boolean unregisterConstraint(PConstraint constraint) {
        return this.constraints.remove(constraint);
    }

    public <ConstraintType> Set<ConstraintType> getConstraintsOfType(Class<ConstraintType> constraintClass) {
        Set<PConstraint> result = CollectionsFactory.getSet();
        for (PConstraint pConstraint : this.constraints) {
            if (!constraintClass.isInstance(pConstraint)) continue;
            result.add(pConstraint);
        }
        return result;
    }

    public PVariable newVirtualVariable() {
        String name;
        while (this.variablesByName.containsKey(name = ".virtual{" + this.nextVirtualNodeID++ + "}")) {
        }
        PVariable var = new PVariable(this, name, true);
        this.addVariable(var);
        return var;
    }

    public PVariable newConstantVariable(Object value) {
        PVariable virtual = this.newVirtualVariable();
        new ConstantValue(this, virtual, value);
        return virtual;
    }

    public IPatternMatcherContext<PatternDescription> getContext() {
        return this.context;
    }

    public Buildable<PatternDescription, StubHandle, Collector> getBuildable() {
        return this.buildable;
    }

    public Set<PVariable> getAllVariables() {
        return this.allVariables;
    }

    public Set<PVariable> getUniqueVariables() {
        return this.uniqueVariables;
    }

    private PVariable getVariableByName(Object name) {
        return this.variablesByName.get(name).getUnifiedIntoRoot();
    }

    public PVariable getOrCreateVariableByName(Object name) {
        if (!this.variablesByName.containsKey(name)) {
            this.addVariable(new PVariable(this, name));
        }
        return this.getVariableByName(name);
    }

    public Set<PConstraint> getConstraints() {
        return this.constraints;
    }

    public PatternDescription getPattern() {
        return this.pattern;
    }

    void noLongerUnique(PVariable pVariable) {
        assert (!pVariable.isUnique());
        this.uniqueVariables.remove(pVariable);
    }
}

