/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.boundary.Disconnectable;
import org.eclipse.incquery.runtime.rete.boundary.InputConnector;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.single.FilterNode;

public class ExternalInputStatelessFilterNode
extends FilterNode
implements Disconnectable {
    IQueryRuntimeContext context = null;
    IInputKey inputKey;
    private InputConnector inputConnector;
    private TupleMask mask;

    public ExternalInputStatelessFilterNode(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer);
        this.mask = mask;
        this.inputConnector = reteContainer.getNetwork().getInputConnector();
    }

    @Override
    public boolean check(Tuple ps) {
        if (this.mask != null) {
            ps = this.mask.transform(ps);
        }
        return this.context.containsTuple(this.inputKey, this.inputConnector.unwrapTuple(ps));
    }

    public void connectThroughContext(ReteEngine engine, IInputKey inputKey) {
        this.inputKey = inputKey;
        this.setTag(inputKey);
        IQueryRuntimeContext context = engine.getRuntimeContext();
        if (!context.getMetaContext().isStateless(inputKey)) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " only applicable for stateless input keys; received instead " + inputKey);
        }
        this.context = context;
        engine.addDisconnectable(this);
    }

    @Override
    public void disconnect() {
        this.context = null;
    }
}

