/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.boundary.ExternalInputEnumeratorNode;
import org.eclipse.incquery.runtime.rete.boundary.ExternalInputStatelessFilterNode;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.incquery.runtime.rete.recipes.InputRecipe;
import org.eclipse.incquery.runtime.rete.remote.Address;

public final class InputConnector {
    Network network;
    protected Table<IInputKey, Tuple, Address<ExternalInputEnumeratorNode>> externalInputRoots = HashBasedTable.create((int)100, (int)1);

    public InputConnector(Network network) {
        this.network = network;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void connectInputFilter(InputFilterRecipe recipe, Node freshNode) {
        ExternalInputStatelessFilterNode inputNode = (ExternalInputStatelessFilterNode)freshNode;
        IInputKey inputKey = (IInputKey)recipe.getInputKey();
        inputNode.connectThroughContext(this.network.getEngine(), inputKey);
    }

    public void connectInput(InputRecipe recipe, Node freshNode) {
        ExternalInputEnumeratorNode inputNode = (ExternalInputEnumeratorNode)freshNode;
        IInputKey inputKey = (IInputKey)recipe.getInputKey();
        Tuple seed = this.nopSeed(inputKey);
        Address<ExternalInputEnumeratorNode> freshAddress = Address.of(inputNode);
        this.externalInputRoots.put((Object)inputKey, (Object)seed, freshAddress);
        inputNode.connectThroughContext(this.network.getEngine(), inputKey, seed);
    }

    public Object wrapElement(Object element) {
        return element;
    }

    public Object unwrapElement(Object wrapper) {
        return wrapper;
    }

    public Tuple wrapTuple(Tuple unwrapped) {
        return unwrapped;
    }

    public Tuple unwrapTuple(Tuple wrappers) {
        return wrappers;
    }

    public Collection<Address<ExternalInputEnumeratorNode>> getAllExternalInputNodes() {
        return this.externalInputRoots.values();
    }

    public Collection<Address<ExternalInputEnumeratorNode>> getAllExternalInputNodesForKey(IInputKey inputKey) {
        return this.externalInputRoots.row((Object)inputKey).values();
    }

    public Address<ExternalInputEnumeratorNode> getExternalInputNodeForKeyUnseeded(IInputKey inputKey) {
        return (Address)this.externalInputRoots.get((Object)inputKey, null);
    }

    public Address<ExternalInputEnumeratorNode> getExternalInputNode(IInputKey inputKey, Tuple seed) {
        if (seed == null) {
            seed = this.nopSeed(inputKey);
        }
        return (Address)this.externalInputRoots.get((Object)inputKey, (Object)seed);
    }

    Tuple nopSeed(IInputKey inputKey) {
        return new FlatTuple(new Object[inputKey.getArity()]);
    }
}

