/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.traceability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;

public class RecipeTraceInfo
implements TraceInfo {
    private Node node;
    ReteNodeRecipe recipe;
    ReteNodeRecipe shadowedRecipe;
    ParentTraceList parentRecipeTraces;

    public ReteNodeRecipe getRecipe() {
        return this.recipe;
    }

    public List<RecipeTraceInfo> getParentRecipeTraces() {
        return Collections.unmodifiableList(this.parentRecipeTraces);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public RecipeTraceInfo(ReteNodeRecipe recipe, Collection<? extends RecipeTraceInfo> parentRecipeTraces) {
        this.recipe = recipe;
        this.parentRecipeTraces = ParentTraceList.from(parentRecipeTraces);
    }

    public RecipeTraceInfo(ReteNodeRecipe recipe, RecipeTraceInfo ... parentRecipeTraces) {
        this(recipe, Arrays.asList(parentRecipeTraces));
    }

    @Override
    public boolean propagateToIndexerParent() {
        return false;
    }

    @Override
    public boolean propagateFromIndexerToSupplierParent() {
        return false;
    }

    @Override
    public boolean propagateFromStandardNodeToSupplierParent() {
        return false;
    }

    @Override
    public boolean propagateToProductionNodeParentAlso() {
        return false;
    }

    @Override
    public void assignNode(Node node) {
        this.node = node;
    }

    public void shadowWithEquivalentRecipe(ReteNodeRecipe knownRecipe) {
        this.shadowedRecipe = this.recipe;
        this.recipe = knownRecipe;
    }

    public ReteNodeRecipe getShadowedRecipe() {
        return this.shadowedRecipe;
    }

    public static class ParentTraceList
    extends ArrayList<RecipeTraceInfo> {
        private static final long serialVersionUID = 8530268272318311419L;

        public static ParentTraceList from(Collection<? extends RecipeTraceInfo> parentRecipeTraces) {
            if (parentRecipeTraces instanceof ParentTraceList) {
                return (ParentTraceList)parentRecipeTraces;
            }
            ParentTraceList result = new ParentTraceList();
            result.addAll(parentRecipeTraces);
            return result;
        }
    }
}

