/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.internal.apiimpl.IncQueryEngineImpl;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.matcher.RetePatternMatcher;
import org.eclipse.incquery.runtime.rete.misc.DeltaMonitor;
import org.eclipse.incquery.runtime.rete.network.Receiver;

public abstract class BaseMatcher<Match extends IPatternMatch>
implements IncQueryMatcher<Match> {
    protected IncQueryEngine engine;
    protected RetePatternMatcher patternMatcher;
    protected ReteEngine reteEngine;
    protected IQuerySpecification<? extends BaseMatcher<Match>> querySpecification;
    private static Object[] fEmptyArray;

    public BaseMatcher(IncQueryEngine engine, IQuerySpecification<? extends BaseMatcher<Match>> querySpecification) throws IncQueryException {
        this.engine = engine;
        IncQueryEngineImpl engineImpl = (IncQueryEngineImpl)engine;
        this.querySpecification = querySpecification;
        this.patternMatcher = this.accessMatcher(engineImpl, querySpecification);
        this.reteEngine = engineImpl.getReteEngine();
        engineImpl.reportMatcherInitialized(querySpecification, this);
    }

    private RetePatternMatcher accessMatcher(IncQueryEngineImpl engine, IQuerySpecification<? extends BaseMatcher<Match>> specification) throws IncQueryException {
        Preconditions.checkArgument((!specification.getStatus().equals((Object)PQuery.PQueryStatus.ERROR) ? 1 : 0) != 0, (Object)("Cannot load erroneous query specification " + specification.getFullyQualifiedName()));
        Preconditions.checkArgument((!specification.getStatus().equals((Object)PQuery.PQueryStatus.UNINITIALIZED) ? 1 : 0) != 0, (Object)("Cannot load uninitialized query specification " + specification.getFullyQualifiedName()));
        try {
            return engine.getReteEngine().accessMatcher(specification);
        }
        catch (QueryPlannerException e) {
            throw new IncQueryException(e);
        }
    }

    protected abstract Match arrayToMatch(Object[] var1);

    protected abstract Match arrayToMatchMutable(Object[] var1);

    protected Object[] matchToArray(Match partialMatch) {
        return partialMatch.toArray();
    }

    protected abstract Match tupleToMatch(Tuple var1);

    protected Object[] emptyArray() {
        if (fEmptyArray == null) {
            fEmptyArray = new Object[this.getSpecification().getParameterNames().size()];
        }
        return fEmptyArray;
    }

    private boolean[] notNull(Object[] parameters) {
        boolean[] notNull = new boolean[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            notNull[i] = parameters[i] != null;
            ++i;
        }
        return notNull;
    }

    @Override
    public Integer getPositionOfParameter(String parameterName) {
        return this.getSpecification().getPositionOfParameter(parameterName);
    }

    @Override
    public List<String> getParameterNames() {
        return this.getSpecification().getParameterNames();
    }

    @Override
    public Collection<Match> getAllMatches() {
        return this.rawGetAllMatches(this.emptyArray());
    }

    protected Collection<Match> rawGetAllMatches(Object[] parameters) {
        ArrayList m = this.patternMatcher.matchAll(parameters, this.notNull(parameters));
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Tuple t : m) {
            matches.add(this.tupleToMatch(t));
        }
        return matches;
    }

    @Override
    public Collection<Match> getAllMatches(Match partialMatch) {
        return this.rawGetAllMatches(partialMatch.toArray());
    }

    @Override
    public Match getOneArbitraryMatch() {
        return this.rawGetOneArbitraryMatch(this.emptyArray());
    }

    protected Match rawGetOneArbitraryMatch(Object[] parameters) {
        Tuple t = this.patternMatcher.matchOne(parameters, this.notNull(parameters));
        if (t != null) {
            return this.tupleToMatch(t);
        }
        return null;
    }

    @Override
    public Match getOneArbitraryMatch(Match partialMatch) {
        return this.rawGetOneArbitraryMatch(partialMatch.toArray());
    }

    protected boolean rawHasMatch(Object[] parameters) {
        return this.patternMatcher.count(parameters, this.notNull(parameters)) > 0;
    }

    @Override
    public boolean hasMatch(Match partialMatch) {
        return this.rawHasMatch(partialMatch.toArray());
    }

    @Override
    public int countMatches() {
        return this.rawCountMatches(this.emptyArray());
    }

    protected int rawCountMatches(Object[] parameters) {
        return this.patternMatcher.count(parameters, this.notNull(parameters));
    }

    @Override
    public int countMatches(Match partialMatch) {
        return this.rawCountMatches(partialMatch.toArray());
    }

    protected void rawForEachMatch(Object[] parameters, IMatchProcessor<? super Match> processor) {
        ArrayList m = this.patternMatcher.matchAll(parameters, this.notNull(parameters));
        for (Tuple t : m) {
            processor.process(this.tupleToMatch(t));
        }
    }

    @Override
    public void forEachMatch(IMatchProcessor<? super Match> processor) {
        this.rawForEachMatch(this.emptyArray(), processor);
    }

    @Override
    public void forEachMatch(Match match, IMatchProcessor<? super Match> processor) {
        this.rawForEachMatch(match.toArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(IMatchProcessor<? super Match> processor) {
        return this.rawForOneArbitraryMatch(this.emptyArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(Match partialMatch, IMatchProcessor<? super Match> processor) {
        return this.rawForOneArbitraryMatch(partialMatch.toArray(), processor);
    }

    protected boolean rawForOneArbitraryMatch(Object[] parameters, IMatchProcessor<? super Match> processor) {
        Tuple t = this.patternMatcher.matchOne(parameters, this.notNull(parameters));
        if (t != null) {
            processor.process(this.tupleToMatch(t));
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public DeltaMonitor<Match> newDeltaMonitor(boolean fillAtStart) {
        DeltaMonitor dm = new DeltaMonitor<Match>(this.reteEngine.getReteNet().getHeadContainer()){

            public Match statelessConvert(Tuple t) {
                return BaseMatcher.this.tupleToMatch(t);
            }
        };
        this.patternMatcher.connect((Receiver)dm, fillAtStart);
        return dm;
    }

    @Deprecated
    protected DeltaMonitor<Match> rawNewFilteredDeltaMonitor(boolean fillAtStart, final Object[] parameters) {
        final int length = parameters.length;
        DeltaMonitor dm = new DeltaMonitor<Match>(this.reteEngine.getReteNet().getHeadContainer()){

            public boolean statelessFilter(Tuple tuple) {
                int i = 0;
                while (i < length) {
                    Object positionalFilter = parameters[i];
                    if (positionalFilter != null && !positionalFilter.equals(tuple.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            public Match statelessConvert(Tuple t) {
                return BaseMatcher.this.tupleToMatch(t);
            }
        };
        this.patternMatcher.connect((Receiver)dm, fillAtStart);
        return dm;
    }

    @Override
    @Deprecated
    public DeltaMonitor<Match> newFilteredDeltaMonitor(boolean fillAtStart, Match partialMatch) {
        return this.rawNewFilteredDeltaMonitor(fillAtStart, partialMatch.toArray());
    }

    @Override
    public Match newEmptyMatch() {
        return this.arrayToMatchMutable(new Object[this.getParameterNames().size()]);
    }

    @Override
    public Match newMatch(Object ... parameters) {
        return this.arrayToMatch(parameters);
    }

    @Override
    public Set<Object> getAllValues(String parameterName) {
        return this.rawGetAllValues(this.getPositionOfParameter(parameterName), this.emptyArray());
    }

    @Override
    public Set<Object> getAllValues(String parameterName, Match partialMatch) {
        return this.rawGetAllValues(this.getPositionOfParameter(parameterName), partialMatch.toArray());
    }

    protected Set<Object> rawGetAllValues(int position, Object[] parameters) {
        if (position >= 0 && position < this.getParameterNames().size() && parameters.length == this.getParameterNames().size() && parameters[position] == null) {
            HashSet<Object> results = new HashSet<Object>();
            this.rawAccumulateAllValues(position, parameters, results);
            return results;
        }
        return null;
    }

    protected <T> void rawAccumulateAllValues(final int position, Object[] parameters, final Set<T> accumulator) {
        this.rawForEachMatch(parameters, new IMatchProcessor<Match>(){

            @Override
            public void process(Match match) {
                accumulator.add(match.get(position));
            }
        });
    }

    @Override
    public IncQueryEngine getEngine() {
        return this.engine;
    }

    @Override
    public IQuerySpecification<? extends BaseMatcher<Match>> getSpecification() {
        return this.querySpecification;
    }

    @Override
    public String getPatternName() {
        return this.querySpecification.getFullyQualifiedName();
    }
}

