/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.handlers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ProjectNatureUpdater
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)currentSelection).toList()) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                new NatureUpdaterJob(project).schedule();
            }
        }
        return null;
    }

    private class NatureUpdaterJob
    extends Job {
        private IProject project;
        private static final String incorrectBuilderID = "org.eclipse.incquery.tooling.ui.projectbuilder";
        private static final String oldNatureID = "org.eclipse.viatra2.emf.incquery.projectnature";

        public NatureUpdaterJob(IProject project) {
            super(String.format("Updating project %s", project.getName()));
            this.project = project;
        }

        private void repairErroneousBuilderEntry(IProject project) throws CoreException {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(incorrectBuilderID)) {
                    commands[i].setBuilderName("org.eclipse.incquery.tooling.core.projectbuilder");
                }
                ++i;
            }
            desc.setBuildSpec(commands);
            project.setDescription(desc, null);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ImmutableList oldIDs;
                this.repairErroneousBuilderEntry(this.project);
                ImmutableList newIDs = this.project.hasNature("org.eclipse.incquery.projectnature") ? ImmutableList.of() : ImmutableList.of((Object)"org.eclipse.incquery.projectnature");
                ImmutableList immutableList = oldIDs = this.project.hasNature(oldNatureID) ? ImmutableList.of((Object)oldNatureID) : ImmutableList.of();
                if (newIDs.size() + oldIDs.size() > 0) {
                    ProjectGenerationHelper.updateNatures((IProject)this.project, (Collection)newIDs, (Collection)oldIDs, (IProgressMonitor)monitor);
                }
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.incquery.tooling.ui", "Error updating project natures", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

